<?php

include_once("class.sendmail.php");

/**
 * Class to manage all tasks related to error conditions of the site, such as
 * logging facilities or alert notifications to the site administrators.
 *
 * @version 1.0
 * @author Ryan Lovelett <RLovelett@simplifiedsoftware.org>
 */

class Error_Handler
{
    /**
     * Logs the specified error
     *
     * @access public
     * @param  mixed $error_msg The error message
     * @param  string $script The script name where the error happened
     * @param  integer $line The line number where the error happened
     */
    function logError($notify = '', $error_msg = "", $script = "", $line = "") {
	
    	//Error_Handler::logToFile($error_msg, $script, $line);		
        Error_Handler::_notify($error_msg, $script, $line);
		
    }


    /**
     * Notifies site administrators of the error condition
     *
     * @access private
     * @param  mixed $error_msg The error message
     * @param  string $script The script name where the error happened
     * @param  integer $line The line number where the error happened
     */
    private function _notify($notify = '', $error_msg = "unknown", $script = "unknown", $line = "unknown") {

        $subject = APP_SITE_NAME . " - Error found! - " . date("m/d/Y H:i:s");
        $msg = "Hello,\n\n";
        $msg .= "An error was found at " . date("m/d/Y H:i:s") . " (" . time() . ") on line '" . $line . "' of script " . "'$script'.\n\n";
        $msg .= "The error message passed to the ".__FILE__." was:\n\n";
        if ((is_array($error_msg)) && (count($error_msg) > 1)) {
            $msg .= "'" . $error_msg[0] . "'\n\n";
            $msg .= "A more detailed error message follows:\n\n";
            $msg .= "'" . $error_msg[1] . "'\n\n";
        } else {
            $msg .= "'$error_msg'\n\n";
        }
        @$msg .= "That happened on page '" . $_SERVER['PHP_SELF'] . "' from IP Address '" . $_SERVER['REMOTE_ADDR'] . ":". $_SERVER['REMOTE_PORT'] . "' coming from the page (referrer) '" . $_SERVER['HTTP_REFERER'] . "'.\n\n";
        @$msg .= "The user agent given was '" . $_SERVER['HTTP_USER_AGENT'] . "'.\n\n";
        $msg .= "Sincerely yours,\nAutomated Error_Handler Class";
        // only try to include the backtrace if we are on PHP 4.3.0 or later
        if (version_compare(phpversion(), "4.3.0", ">=")) {
            $msg .= "\n\nA backtrace is available:\n\n";
            ob_start();
            $backtrace = debug_backtrace();
            // remove the two entries related to the error handling stuff itself
           	array_shift($backtrace);
            array_shift($backtrace);
            // now we can print it out
            print_r($backtrace);
            $contents = ob_get_contents();
            $msg .= $contents;
            ob_end_clean();
        }
        // avoid triggering an email notification about a query that 
        // was bigger than max_allowed_packet (usually 16 megs on 3.23 
        // client libraries)
        if (strlen($msg) > 16777216) {
            exit();
        }
		   
		SendMail::_sendMail($notify,"Automated System",$notify,$subject,$msg);
    }


    /**
     * Logs the error condition to a specific file
     *
     * @access public
     * @param  mixed $error_msg The error message
     * @param  string $script The script name where the error happened
     * @param  integer $line The line number where the error happened
     */
    private function logToFile($error_msg = "unknown", $script = "unknown", $line = "unknown") {

        $msg = "[" . date("D M d H:i:s Y") . "] ";
        $msg .= "An error was found on line '" . $line . "' of script " . "'$script'.\n\n";
        $msg .= "The error message passed to us was:\n\n";
        if ((is_array($error_msg)) && (count($error_msg) > 1)) {
            $msg .= "'" . $error_msg[0] . "'\n\n";
            $msg .= "A more detailed error message follows:\n\n";
            $msg .= "'" . $error_msg[1] . "'\n\n";
        } else {
            $msg .= "'$error_msg'\n\n";
        }
        // only try to include the backtrace if we are on PHP 4.3.0 or later
        if (version_compare(phpversion(), "4.3.0", ">=")) {
            $msg .= "\n\nA backtrace is available:\n\n";
            ob_start();
            $backtrace = debug_backtrace();
            // remove the two entries related to the error handling stuff itself
            array_shift($backtrace);
            array_shift($backtrace);
            // now we can print it out
            print_r($backtrace);
            $contents = ob_get_contents();
            $msg .= $contents;
            ob_end_clean();
        }
		
		//Log::InsertIntoLog($_SESSION['userid'], "Error String From $script", "Error String From $script", $msg);		
    }
}
?>