<?php
// Form to encode/decode text dinamicaly
require_once(dirname(__FILE__).'/ascii85.class.php');

$form = get_form();
$result = isset($_POST['submit']) ? '<pre id="result">'.get_result().'</pre>' : '';

header('Content-type: text/html; charset=UTF-8');
echo <<<HTML
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>Example of ASCII85 Class usage</title>
<style type="text/css" rel="stylesheet"><!--
form { border: 1px outset #CCCCCC; padding: .5em 1em; width: 25em; }
label { vertical-align: top; }
pre { border: 1px solid #000000; padding: .5em; }
#result { border: 1px outset #CCCCCC; margin-top: 1em; padding: .5em; }
--></style>
</head>
<body>

<h1>Try it!</h1>
{$form}
{$result}

</body>
</html>
HTML;


/**
 * Create a form
 */
function get_form() {
if (isset($_POST['submit'])) {
    $value      = htmlentities($_POST['value'], ENT_COMPAT, 'UTF-8');
    $op_method1 = ($_POST['method'] == 'encode') ? ' selected="selected"' : '';
    $op_method2 = ($_POST['method'] == 'decode') ? ' selected="selected"' : '';
    $op_variation1 = ($_POST['variation'] == ascii85::BASIC)   ? ' selected="selected"' : '';
    $op_variation2 = ($_POST['variation'] == ascii85::ADOBE)   ? ' selected="selected"' : '';
    $op_variation3 = ($_POST['variation'] == ascii85::BTOA)    ? ' selected="selected"' : '';
    $split_pos = round(abs($_POST['split_pos']));
} else {
    $value = '';
    $op_method1 = '';
    $op_method2 = '';
    $op_variation1 = '';
    $op_variation2 = '';
    $op_variation3 = '';
    $op_variation4 = '';
    $split_pos = '80';
}
$op1 = ascii85::BASIC;
$op2 = ascii85::ADOBE;
$op3 = ascii85::BTOA;

return <<<HTML
<form method="post" action="test.php">
  <p>
    <label for="value">Value:</label>
    <textarea id="value" name="value" cols="30" rows="5" >{$value}</textarea>
  </p>
  <p>
    <label for="method">Method:</label>
    <select id="method" name="method">
      <option value="encode"{$op_method1}>Encode</option>
      <option value="decode"{$op_method2}>Decode</option>
    </select>
  </p>
  <p>
    <label for="variation">Variation:</label>
    <select id="variation" name="variation">
      <option value="{$op1}"{$op_variation1}>Basic</option>
      <option value="{$op2}"{$op_variation2}>Adobe</option>
      <option value="{$op3}"{$op_variation3}>BTOA</option>
    </select>
  </p>
  <p>
    <label for="split_pos">Split Position:</label>
    <input type="text" id="split_pos" name="split_pos" value="{$split_pos}" />
  </p>
  <p>
    <input type="submit" name="submit" value="Submit" />
  </p>
</form>
HTML;
}

/**
 * Process form
 */
function get_result() {
    if ($_POST['method'] == 'encode') {
        return ascii85::encode($_POST['value'], $_POST['variation'], $_POST['split_pos']);
    } elseif ($_POST['method'] == 'decode') {
        try {
            return ascii85::decode($_POST['value'], $_POST['variation']);
        } catch (Exception $e) {
            return 'Error '.$e->getCode().': '.$e->getMessage();
        }
    } else {
        return 'Undefined method "'.htmlentities($_POST['method']).'"';
    }
}
