<?php
// Some examples of class usage
require_once(dirname(__FILE__).'/ascii85.class.php');


$text = 'A text with many zero-bytes ('.str_repeat(chr(0), 10).') and many spaces ('.str_repeat(' ', 10).') end.';

// Encode using DEFAULT algorithm
$basic_encoded = ascii85::encode($text, ascii85::BASIC, 72);
try {
    $basic_decoded = ascii85::decode($basic_encoded);
} catch (Exception $e) {
    $basic_decoded = 'Error '.$e->getCode().': '.$e->getMessage();
}

// Encode using ADOBE variation
$adobe_encoded = ascii85::encode($text, ascii85::ADOBE, 72);
try {
    $adobe_decoded = ascii85::decode($adobe_encoded, ascii85::ADOBE);
} catch (Exception $e) {
    $adobe_decoded = 'Error '.$e->getCode().': '.$e->getMessage();
}


// Encode using BTOA variation
$btoa_encoded = ascii85::encode($text, ascii85::BTOA, 72);
try {
    $btoa_decoded = ascii85::decode($btoa_encoded, ascii85::BTOA);
} catch (Exception $e) {
    $btoa_decoded = 'Error '.$e->getCode().': '.$e->getMessage();
}

// Format ant print result
$text          = htmlentities($text,          ENT_COMPAT, 'UTF-8');
$basic_encoded = htmlentities($basic_encoded, ENT_COMPAT, 'UTF-8');
$basic_decoded = htmlentities($basic_decoded, ENT_COMPAT, 'UTF-8');
$adobe_encoded = htmlentities($adobe_encoded, ENT_COMPAT, 'UTF-8');
$adobe_decoded = htmlentities($adobe_decoded, ENT_COMPAT, 'UTF-8');
$btoa_encoded  = htmlentities($btoa_encoded,  ENT_COMPAT, 'UTF-8');
$btoa_decoded  = htmlentities($btoa_decoded,  ENT_COMPAT, 'UTF-8');

header('Content-type: text/html; charset=UTF-8');
echo <<<HTML
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>Example of ASCII85 Class usage</title>
<style type="text/css" rel="stylesheet"><!--
pre { border: 1px solid #000000; background-color: #FFFFFF; padding: .5em; }
h2 { margin: 0; }
div { padding: 1em; margin-bottom: .2em; }
.basic { border: 1px outset #EEEEFF; background-color: #EEEEFF; }
.adobe { border: 1px outset #EEFFEE; background-color: #EEFFEE; }
.btoa { border: 1px outset #FFEEEE; background-color: #FFEEEE; }
--></style>
</head>
<body>

<h1>Example of Ascii85 Class usage</h1>
<p>Original text:<br /><pre>{$text}</pre></p>

<div class="basic">
<h2>Basic</h2>
<p>Definition: this algorithm convert a binary sequence to a text sequence using 
   basicaly 85 characters. The idea is to represent a tuple of four bytes as
   a tuple of five printable characters.</p>
<p>Encoded:<br /><pre>{$basic_encoded}</pre></p>
<p>Decoded:<br /><pre>{$basic_decoded}</pre></p>
</div>

<div class="adobe">
<h2>Adobe Variant</h2>
<p>Diferences: this variant is delimited by &lt;~ and ~&gt;.
   It uses "z" character to represent a tuple with four
   zero-byte (0x00).</p>
<p>Encoded:<br /><pre>{$adobe_encoded}</pre></p>
<p>Decoded:<br /><pre>{$adobe_decoded}</pre></p>
</div>

<div class="btoa">
<h2>BTOA Variant</h2>
<p>Diferences: this variant is delimited by "xbtoa Begin" and "xbtoa End".
   It includes some verification data (text length, check XOR, check SUM and check ROT).
   It uses "z" character to represent a tuple with four zero-byte (0x00) and
   "y" character to represent a tuple with four white-space (0x22).</p>
<p>Encoded:<br /><pre>{$btoa_encoded}</pre></p>
<p>Decoded:<br /><pre>{$btoa_decoded}</pre></p>
</div>

</body>
</html>
HTML;
