<?php
  
  /**------------------------------------------------------------------------------
   * Title:        uploadmanager
   * Filename:     uploadmanager.class.php
   * Version:      0.1 alpha
   * Author:       Richard Keizer
   * Email:        ra dot keizer at gmail dot com
   *-------------------------------------------------------------------------------
   * COPYRIGHT (c) 2011 Richard Keizer
   *
   * The source code included in this package is free software; you can
   * redistribute it and/or modify it under the terms of the GNU General Public
   * License as published by the Free Software Foundation. This license can be
   * read at:
   *
   * http://www.opensource.org/licenses/gpl-license.php
   *
   * This program is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   *------------------------------------------------------------------------------
   *
   *
   */
  
  class UploadManager {
    protected $host;
    protected $port;
    
    protected $mainsocket;
    protected $clientsocket;
    
    public function __construct($port=5600) {
      $this->host = $_SERVER['SERVER_ADDR']; //$_SERVER['SERVER_NAME'];   
      $this->port = $port;
      ob_implicit_flush();
    }
    
    public function renderForm() {
      ?>
        <script>
          function upload(form) {
            document.uploader = {};
            document.uploader.form = form;
            document.uploader.notifyReady = function() {
              this.form.submit();
            }
            var el = document.getElementById('uploader_server');
            el.src = '?action=startlistening';
            return false;
          }
        </script>
        <div style='position:relative; border:1px solid gray; width:600px;'>
          <form onsubmit='return upload(this);' target='uploader_target' action='<?php echo "http://{$this->host}:{$this->port}/upload/test.php";?>' enctype='multipart/form-data' method='post'>
            <input type='file' name='file1'><br>
            <input type='file' name='file2'><br>
            <input type='submit' value='Send'>
          </form>
          <button onclick='document.getElementById("uploader_target").src="";'>stop</button>
          <iframe id='uploader_target' name='uploader_target' src='' frameborder='0' style='width:0;height:0px;border:none'></iframe>
          <iframe id='uploader_server' name='uploader_server' src='' frameborder='0' style='position:relative;width:100%;border:none'></iframe>
        </div>
      <?php
    }

    public function shutdown() {
      if (is_resource($this->clientsocket)) {
        socket_set_block($this->clientsocket);
        usleep(500);
        socket_set_option($this->clientsocket, SOL_SOCKET, SO_LINGER, $opt = array('l_onoff' => 1, 'l_linger' => 1));
        usleep(500);
        socket_close($this->clientsocket);
        usleep(500);
      }

      if (is_resource($this->mainsocket)) {
        socket_set_block($this->mainsocket);
        usleep(500);
        socket_set_option($this->mainsocket, SOL_SOCKET, SO_LINGER, $opt = array('l_onoff' => 1, 'l_linger' => 1));
        usleep(500);
        socket_close($this->mainsocket);
        usleep(500);
      }
    }
    
    public function startListening() {
      set_time_limit(0);
      register_shutdown_function(array($this, 'shutdown'));

      $this->mainsocket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
      usleep(500);
      
      socket_set_nonblock($this->mainsocket);
      usleep(500);
      
      socket_set_option($this->mainsocket, SOL_SOCKET, SO_REUSEADDR, 1);
      usleep(500);
      socket_bind($this->mainsocket, $this->host, $this->port);
      usleep(500);
      socket_listen($this->mainsocket, 128); 
      usleep(500);

      flush();
      echo "
      <html>
        <head>
        </head>
      <body>
        <script>parent.document.uploader.notifyReady();</script>
        <div id='bar' style='position:relative; width:0px; height:24px; line-height:24px; text-align:left; border:1px outset black; color:white; font-size: 18px; font-family: Verdana; background: url(barbackground.jpg)'></div>
        <div id='summary'></div>
        <script>var bar = document.getElementById('bar');</script>
        <script>var summary = document.getElementById('summary');</script>";
      echo str_repeat("<span></span>", 500);
      flush();
      
      if (socket_select($r = array($this->mainsocket), $w = NULL, $e = NULL, 60) > 0) {  //WAIT for data...
        $this->clientsocket = socket_accept($this->mainsocket);
        usleep(500);
        
        socket_set_nonblock($this->clientsocket);
        usleep(500);

        socket_clear_error($this->clientsocket);
        usleep(500);
        

        $blocksize = 1024*16;
        
        
        $this->buffer = new Buffer(array($this, 'onSpeedChange'), array($this, 'onProgressChange'));
        
        $status = 200;
        
        while (!$this->buffer->isFull()) {
          
          /*
           * this took me 2 days of headache...
           *
           * all available resources on the web about socket reading with PHP don't seem to work properly.
           * especially on poor connections data won't come through if we don't handle errors while reading.
           * there is a special error-case called SOCKET_EAGAIN (resource temporarily unavailable)
           * on which *any* client *should* anticipate by retrying.
           * I learned this the hard way: on my local server large filetransfers were succesfull, but when I moved
           * to my *slow* webserver running on a NAS large transfers kept breaking.
           *
           */
          $input = socket_read($this->clientsocket, $blocksize, PHP_BINARY_READ);
          
          if ($input==='') {  //buffer=empty, connection was lost!
            $status = 1;
            break;
          }

          if ($input===false) {
            $error = socket_last_error($this->clientsocket);
            socket_clear_error($this->clientsocket);
            
            if ($error==SOCKET_EINTR) continue;
            
            if ($error==SOCKET_EAGAIN) {
              $s = socket_select($r = array($this->clientsocket), $w = NULL, $e = NULL, 60);
              if ($s==1) continue;
              $error = socket_last_error($this->clientsocket);
              socket_clear_error($this->clientsocket);
              //todo: handle timeout here!
              
            }
            
            //throw new Exception($error);      //todo: proper feedback to client
            $status = 1;
            break;
          }

          $this->buffer->append($input);
          
          
          /*
           *  if the contentlength is not determined yet then check if the header has completed.
           *  if so, we can calculate the size of the request.
           *  the total size is used to determine if we can stop reading
           *
           *  todo: use the httprequestparser class for this.
           */
          if (!$this->buffer->hasLimitedSize()) {
            $p = strpos($this->buffer->getData(), "\r\n\r\n");
            if ($p > 0) {
              $request = HTTPRequestParser::parse(substr($this->buffer->getData(), 0, $p+4));
              
              $this->buffer->setMaxSize($request['header']['Content-Length'][0] + $p + 4);
              
              $blocksize = max(1024*32, min(256, round($this->buffer->getMaxSize()/100)));
            }
          }
        }
        
        
        if ($status==200) {

          //here we parse the raw post data.
          //todo: build in errorchecking in parser and respond with proper errorcode to client.
          //parsing can take a while when files are big, the client will stay throbbing..
          
          echo "<script>bar.innerHTML='postprocessing.. please wait.. <img src=\'throbber.gif\'>';</script>";
          echo str_repeat("<span></span>", 500);
          flush();
          
          $request = HTTPRequestParser::parse($this->buffer->getData());
          $httpbody = $request['body'];
          foreach($httpbody as $key => $part) {
            if (preg_match_all("/filename=\"?([^\"]+)\"?/smi", $part['header']['Content-Disposition'][2], $matches)) {
              file_put_contents($matches[1][0], $part['body']);
            }
          }
          
          echo "<script>bar.innerHTML='done!';</script>";
          echo str_repeat("<span></span>", 500);
          flush();
          
          $response = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nServer: Pure PHP Uploader\r\n\r\n";
          socket_write($this->clientsocket, $response);
          usleep(5000);
        } else {
          echo "<script>bar.style.width='100%';bar.innerHTML='timeout';</script>";
          echo str_repeat("<span></span>", 500);
          flush();
        }
      }
    }
        
    public function onSpeedChange() {
      echo "<script>";
      echo "summary.innerHTML='{$this->buffer->getSpeed()} kB/s';";
      echo "</script>";
    }
        
    public function onProgressChange() {
      echo "<script>";
      echo "bar.style.width='{$this->buffer->getProgress()}%';bar.innerHTML='{$this->buffer->getProgress()}%';";
      echo "</script>";
    }
  }
        
        


