<?php

  /**------------------------------------------------------------------------------
   * Title:        uploadmanager
   * Filename:     uploadmanager.class.php
   * Version:      0.1 alpha
   * Author:       Richard Keizer
   * Email:        ra dot keizer at gmail dot com
   *-------------------------------------------------------------------------------
   * COPYRIGHT (c) 2011 Richard Keizer
   *
   * The source code included in this package is free software; you can
   * redistribute it and/or modify it under the terms of the GNU General Public
   * License as published by the Free Software Foundation. This license can be
   * read at:
   *
   * http://www.opensource.org/licenses/gpl-license.php
   *
   * This program is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   *------------------------------------------------------------------------------
   *
   * HTTPRequest parser recursively parses raw HTTP request into a readable structure
   *  functionality is sufficient for parsing a posted form request, but can be
   *  extended.
   */
  
  class HTTPRequestParser {
    
    static public function parse($input) {
      $parts = preg_split("/\R/m", $input, 2);
      $res = self::parsePart($parts[1]);
      $res['method'] = $parts[0];
      return $res;
    }
    
    static protected function parseHeader($input) {
      $header = array();
      foreach(preg_split("/\R(?=[^ ])/m", $input) as $line) {  //split: linebreak not followed by space
        $pair = preg_split("/\: +/m", $line, 2);
        $header[$pair[0]] = preg_split("/; */m", $pair[1]);
      }
      return $header;
    }
    
    static protected function parseBody($input, $header) {
      switch(isset($header['Content-Type']) ? $header['Content-Type'][0] : 'text/plain') {
        case 'multipart/digest':
        case 'multipart/mixed':
        case 'multipart/form-data': return self::splitByBoundary($input, trim($header['Content-Type'][1], 'boundary='));
          
        default: return $input;
      }
    }
    
    static protected function splitByBoundary($input, $boundary) {
      $body = array();
      foreach(preg_split("/\R?--{$boundary}(--)?\R?/m", $input, NULL, PREG_SPLIT_NO_EMPTY) as $part) $body[] = self::parsePart($part);
      return $body;
    }
    
    static protected function parsePart($input) {
      $parts = preg_split("/(\r\n){2}/m", $input, 2);
      $header = self::parseHeader($parts[0]);
      $body = isset($parts[1]) ? self::parseBody($parts[1], $header) : NULL;
      return array('header' => $header, 'body' => $body);
    }
  }
