<?php

class webmontage{

	var $htmlfile="canvas.html";
	var $picturedir = "";
	var $dictionary = "/usr/share/dict/words";
	var $gsize = 2;
	var $gterm;
	var $gpages = 10;
	var $gsafe = 'off';
	var $cvsname = "canvas.jpg";
	var $cvsmap = "canvasmap.html";
	var $cvsbordergif;
	var $anotatex;
	var $anotatey;
	var $anotatefont = 1;
	var $cvsmapmax = 50;
	var $cvswidth = 800;
	var $cvsheight = 600;
	var $picturestr;
	var $pictureurl;
	var $picturewidth;
	var $pictureheight;
	var $keeppic = false;
	var $refresh = 5;
	var $cyclecount = 1;
	var $cyclewait = 5;
	var $placerx;
	var $placery;
	var $restart = false;
	var $cmdline;
	var $version = "1.1.1";
	var $date = "28-12-2007";
	var $update = "28-12-2007";
	var $dimensions=array('icon','small','medium','large','xlarge','xxlarge','huge');

function cycle(){
	
	srand((float) microtime() * 10000000);
	if($this->restart){
		unlink($this->cvsname);
		unlink($this->cvsmap);
	}
	$count=0;
	while($count < $this->cyclecount){
		$this->picturestr="";
		while($this->is_image($this->picturestr) == false){
			$this->random_google_picture();
			$this->retrieve_file();
		}
		$this->canvas_drop();
		if($this->cyclecount > 1) sleep($this->cyclewait);
		$count++;
	}
}
function wallpaper(){
	srand((float) microtime() * 10000000);
	$this->picturestr="";
	if($this->restart){
		unlink($this->cvsname);
	}
	$status=0;
	while($this->is_image($this->picturestr) == false){
		$this->random_google_picture();
		$this->retrieve_file();
		$status++;
		if($status == 3) exit;
	}
	$this->set_wallpaper();
}
function set_wallpaper(){
	$imsrc = imagecreatefromstring($this->picturestr);
	$imdst = ImageCreateTrueColor($this->cvswidth,$this->cvsheight);
	imagecopyresized  ( $imdst, $imsrc, 0, 0, 0, 0, $this->cvswidth,$this->cvsheight, $this->picturewidth, $this->pictureheight);
	imagejpeg($imdst,$this->cvsname);
	imagedestroy($imsrc);
	imagedestroy($imdst);
	if($this->keeppic) file_put_contents($this->picturedir.$this->pfilename(),$this->picturestr);
	if(strlen($this->cvsbordergif) > 0) $this->drop_border();
	$this->cmdline = str_replace  ( '%image%'  , $this->cvsname  ,  $this->cmdline);
	exec($this->cmdline);
}
function drop_border(){
	$imsrc = imagecreatefromgif($this->cvsbordergif);
	$imdst = Imagecreatefromjpeg($this->cvsname);
	$this->borderwidth = imagesx($imsrc);
	$this->borderheight = imagesy($imsrc);
	imagecopyresized  ( $imdst, $imsrc, 0, 0, 0, 0, $this->cvswidth,$this->cvsheight, $this->borderwidth, $this->borderheight);
	$black = imagecolorallocate($imdst, 0, 0, 0);
	$white = imagecolorallocate($imdst, 255, 255, 255);
	if($this->anotatex && $this->anotatey){
		imagestring($imdst, $this->anotatefont, $this->anotatex, $this->anotatey, "Picture retrieved by webmontage ".$this->version." at : ".$this->pictureurl." found with ".$this->gterm, $white);
		imagestring($imdst, $this->anotatefont, $this->anotatex+1, $this->anotatey-1, "Picture retrieved by webmontage ".$this->version." at : ".$this->pictureurl." found with ".$this->gterm, $black);
	}
	imagejpeg($imdst,$this->cvsname);
	if($this->keeppic) imagejpeg($imdst,$this->picturedir.$this->pfilename());
	imagedestroy($imsrc);
	imagedestroy($imdst);
}

function random_google_picture(){
	$this->gterm=$this->pickterm($this->dictionary);
	$page=mt_rand(1,$this->gpages); // we choose from $gpages pages
	$num=20; //picture per page
	$picture=mt_rand(0,19); //the picture we choose
	$pattern="#/imgres\?imgurl=.*?&#m";

	$search_url="http://images.google.com/images?q=".$this->gterm."&start=" . $page*$num."&num="  . $num."&gbv=1&safe=".$this->gsafe."&imgsz=".$this->dimensions[$this->gsize];

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $search_url);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$page=curl_exec($ch);
	curl_close($ch);

	$mpage=str_replace("<","\n<",$page);
	$page=str_replace(">","\n>",$mpage);
	preg_match_all  ($pattern  , $page , $matches );

	$this->pictureurl=rawurldecode(substr($matches[0][$picture],15,-1));
	
	return;
}

function retrieve_file(){

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $this->pictureurl);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	$this->picturestr=curl_exec($ch);
	curl_close($ch);
}
function is_image(){
	if($this->picturestr == "") return false;
	$im = imagecreatefromstring($this->picturestr);
	if ($im !== false) {
		$this->picturewidth = imagesx($im);
		$this->pictureheight = imagesy($im);
		imagedestroy($im);
		return true;
	}
	else {
		return false;
	}
}
function pfilename(){
	$fninfo=pathinfo($this->pictureurl);
	return $fninfo['basename'];
}

function create_canvas(){
	$im = imagecreate($this->cvswidth, $this->cvsheight);
	imagejpeg($im, $this->cvsname, 80);
	imagedestroy($im);
}
function buildpage(){
$page = '<html>
<head>
<meta http-equiv="refresh" content="'.$this->refresh.';URL='.$this->htmlfile.'" />
</head>
<body style="margin: 0;background-color: #000000;">
<iframe style="margin:auto;border:0;width:100%;height:100%;" src="'.$this->cvsname.'" ></iframe>
</body>
</html>
';
	file_put_contents($this->htmlfile,$page);
}

function pickterm($file){
	$list=file($file);
	
	while(substr($list[0],0,2) == "//") {
		array_shift($list);
	}
	$rand_keys = array_rand($list, 2);
	
	return trim($list[$rand_keys[0]]);
}

function canvas_drop(){
	if(!file_exists($this->cvsname)) $this->create_canvas();
	$this->placerx=mt_rand(-10,$this->cvswidth);
	$this->placery=mt_rand(-10,$this->cvsheight);
	if(!$imsrc = imagecreatefromstring($this->picturestr)) return;
	$this->picturewidth = imagesx($imsrc);
	$this->pictureheight = imagesy($imsrc);
	$imdst = imagecreatefromjpeg($this->cvsname);
	$test=imagecopymerge  ($imdst  , $imsrc  , $this->placerx  , $this->placery  , 0  , 0  , $this->picturewidth, $this->pictureheight, 100  );
	$test=imagejpeg($imdst, $this->cvsname, 90);
	if($this->keeppic) file_put_contents($this->picturedir.$this->pfilename(),$this->picturestr);
	$this->imagemap();
	imagedestroy($imsrc);
	imagedestroy($imdst);
	if(strlen($this->cvsbordergif) > 0) $this->drop_border();
}

function imagemap(){
	$tstr="";
	if(file_exists($this->cvsmap)) {
		$curmap=file($this->cvsmap);
		array_pop($curmap);
		array_pop($curmap);
		array_shift($curmap);
		if(count($curmap) > $this->cvsmapmax) array_pop($curmap);
		$tstr = trim(implode("",$curmap));
	}
	$mapstr='<map name="base">'."\n";
	$mapstr .='<area alt="'.$this->gterm.'" title="'.$this->gterm.'" SHAPE=RECT COORDS="'.$this->placerx.','.$this->placery.','.($this->placerx+$this->picturewidth).','.($this->placery+$this->pictureheight).'" HREF="'.$this->pictureurl.'">'."\n";
	if($tstr > "") $mapstr .= $tstr."\n";
	$mapstr .= '</MAP>'."\n".'<IMG SRC="'.$this->cvsname.'" USEMAP="#base" style="margin-left: auto; border: solid white 0px;">';
	file_put_contents($this->cvsmap,$mapstr);
	$page = '<html>
<head>
<meta http-equiv="refresh" content="'.$this->refresh.';URL='.$this->htmlfile.'" />
</head>
<body style="margin: 0;background-color: #ffffff;">
'.$mapstr.'
</body>
</html>
';
	file_put_contents($this->htmlfile,$page);

}
// End class
}
?>