<?php

/**********************************************************************************
****** class name : funny_strings                                                             
****** language   : php                                                                                      
****** author     : Martin Lacher                                                                            
****** contact    : m|a|r|t|i|n dot l|a|c|h|e|r at w|e|b dot d|e                                                  
****** version    : 1.0                                                                           
****** date       : 13/11/2004
****** licence    : gnu-gpl
******
****** Free for private use, for commercial use contact the author.
******
**********************************************************************************/

/**********************************************************************************
******  Transforms text into h4xx0r- or eLiTe-StYlE or shlefufs Wdors
**********************************************************************************/

/**********************************************************************************
******  List of public funtions:
******    - bool set_separator_read(string character)
******    - bool set_separator_write(string character)
******    - bool set_elite_init(int init)
******
******    - string elite(string text)
******    - string half_elite(string text)
******    - string h4xx0r(string text)
******    - string shuffle_word(string word)
******    - string shuffle_text(string text)
******
**********************************************************************************/

class funny_string
{

	var $separator_read = ' ';
	var $separator_write = ' ';
	var $elite_init = 0;
	
	/*************************************************************************
	*****  The read_separator will be used, when a text is separeted    ******
	*****  into words. It indicates where one word ends and where the   ******
	*****  next one starts. It is only one character.                   ******
	**************************************************************************/
	
	function set_separator_read($c) {
		
		if(strlen(trim($c))>1) return false;
		else {
			$this->separator_read = $c;
			return true;
		}
	}
	
	/*************************************************************************
	*****  The write_separator will be used, when a text is joined      ******
	*****  after being shuffled. It is set between the words. It is     ******
	*****  only one character.                                          ******
	**************************************************************************/
	
	function set_separator_write($c) {
		
		if(strlen(trim($c))>1) return false;
		else {
			$this->separator_write = $c;
			return true;
		}
	}
		
	/*************************************************************************
	*****  This function set a initial number for elite transformation  ******
	*****  It accepts all kinds of ints an floats, but reduces them to  ******
	*****  0 or 1.                                                      ******
	**************************************************************************/
	
	function set_elite_init($i) {
		
		$i = floor(abs($i % 2));
		$this->elite_init = $i;
	}
	
	/*************************************************************************
	*****  This Function checks only whether a character is a letter   *******
	*****  or not. used in shuffle_word().                             *******
	**************************************************************************/
	
	function chr_check($c) {
	
		$oc = ord($c);
		if ($oc >= 65 && $oc <= 90) return true;
		elseif ($oc >= 97 && $oc <= 122) return true;
		else return false;
	}
	
	
	/*************************************************************************
	*****  This function changes the case of a single character         ******
	**************************************************************************/
	
	function change_case($c) {
	
		$oc = ord($c);
		if ($oc >= 65 && $oc <= 90) return chr($oc+32);
		elseif ($oc >= 97 && $oc <= 122) return chr($oc-32);
		else return $c;
	}
	
	/*************************************************************************
	*****  This function transforms a text into h4xx0r-5ty|3            ******
	**************************************************************************/

	function h4xx0r($s) {
	
		$replacements = array("A" => "4", "l" => "|", "H" => "|-|",
					"C" => "(", "e" => "3", "o" => "0",
					"O" => "0", "G" => "6", "g" => "6",
					"i" => "1", "S" => "5", "N" => "/\/",
					"w" => "vv","B" => "8", "V" => "\/",
					"s" => "5", "f" => "ph" );
		
		$s =strtr($s, $replacements);
		return $s;
	}
	
	/*************************************************************************
	*****  This function transforms a text into eLiTe-StYlE             ******
	**************************************************************************/
	
	function elite($s) {
	
		$s1 = "";
		for($i=0; $i<strlen($s); $i++) {
			if($i % 2 == $this->elite_init)	$s1 .= $s[$i];
			else $s1 .= $this->change_case($s[$i]);
		}
		return $s1;
	}
	
	/*************************************************************************
	*****  This function transforms a text into HALF elite STYLE        ******
	**************************************************************************/
	
	function half_elite($s) {
	
		$wds = explode($this->separator_read, $s);
		$wds2 = array();
		
		$i = 0;
		foreach($wds as $w) {
			if($i % 2 == $this->elite_init) $w2 = strtoupper($w);
			else $w2 = strtolower($w);
			$wds2[] = $w2;
			$i++;
		}
		
		return join($this->separator_write, $wds2);
	}
	
	/*************************************************************************
	*****  This function shuffles one single word.                      ******
	**************************************************************************/
	
	function shuffle_word($w) {
	
			$w = explode($this->separator_read, trim($w));
			$w = $w[0];
						
			$first = "";
			$middle = "";
			$last = "";
					
			$first = substr($w, 0, 1);
			$fpos = 0;
			while(!$this->chr_check($w[$fpos]) && $fpos < strlen($w)) {
				$fpos++;
				$first .= $w[$fpos];
			}
			
			if($fpos != strlen($w)) {	
				$lpos = strlen($w)-1;
				if($lpos > $fpos) {
					$last = substr($w, -1);
					while(!$this->chr_check($w[$lpos])  && $lpos >= 0 && $lpos > $fpos) {
						$lpos--;
						$last = $w[$lpos] . $last;
					}		
				}
				$middle = str_shuffle(substr($w, strlen($first), strlen($w)-strlen($first)-strlen($last)));
			}
			return $first.$middle.$last;
	}
		
	/*************************************************************************
	*****  This function shuffles a whole text.                         ******
	**************************************************************************/
	
	function shuffle_text($str)
	{
		$words = explode($this->separator_read, $str);		
		$shuffled = array();
		
		foreach($words as $w) {
			$w = $this->shuffle_word($w);	
			$shuffled[] = $w;
		}
	
		return implode($this->separator_write, $shuffled);	
	}
}

?>
