/*******************************************************************************************
 * This class will convert file size in different units like Bytes/KB/MB/GB/TB
 * PHP provides a function filesize() which always return file size in bytes.
 * This class will help to get the file size by Bytes/KB/MB/GB/TB format.
 * This class consists of two functions  fileSizeByFileName(),fileSizeConversion()
 * By : SUBHRANIL DALAL
 * Mindfire Solutions (www.mindfiresolutions.com)       Date : 07/10/2009
 * ****************************************************************************************/

 /*****************************************************************************************
  * Function Name   : fileSizeByFileName()
  * Description     : This function will take the file name as argument and return
  *                   file size in Bytes/KB/MB/GB/TB format.
  * InputArgs       : $fileName (Required)(pass the absolute location of a file)
  *                   $roundOff (Optional) (by default it will round off upto 
  *                             2 decimal palces, can be changed as requirement)
  * OutPut          : Return file size in B/KB/MB/GB/TB
  * Use             : $obj = new getFileSize();
  *                   echo $obj->fileSizeByFileName('file_size.pdf');
  *                   echo $obj->fileSizeByFileName('file_size.pdf', 5);
  * **************************************************************************************/
 
 /*****************************************************************************************
  * Function Name        : fileSizeConversion()
  * Description          : Take the file size in any unit (B/KB/MB/GB/TB) and convert it to
  *                        required unit.
  * InputArgs            : $fileSize (Required)(The numeric size value of file in any unit)
  * 
  *                        $currentUnit (Optional)(The file size unit which will be converted
  *                                      to the required unit, default it will take byte as
  *                                      default unit. This parameter will pass as B/KB/MB/GB/TB
  *                                      as file size unit.)
  *
  *                        $requiredUnit (Optional) (This parameter for the unit which we want
  *                                       to get the file size.If nothing is passed it will
  *                                       represend in maxime possible unit conversion.
  *                                       This parameter will pass as B/KB/MB/GB/TB format )
  *
  *                        $roundOff (Optional) (by default it will round off upto 
  *                                      2 decimal palces, can be changed as requirement)
  * OutPut               : Return file size in B/KB/MB/GB/TB or required format
  * Use                  : $obj = new getFileSize();
  *                        echo $obj->fileSizeConversion(2030);
  *                        echo $obj->fileSizeConversion(45678903,'B');
  *                        echo $obj->fileSizeConversion(367830,'B','MB');
  *                        echo $obj->fileSizeConversion(5.34,'GB','MB',5);
  *                        echo $obj->fileSizeConversion(6.84,'MB','GB',10);
  * ******************************************************************************************/
 
class getFileSize {
    private $size;
    function __construct(){
    $this->size = array(
            array(
                'minSize' => '1208925819614629174706176',
                'unit' => 'YB',
                'rank' => '9'
            ),
            array(
                'minSize' => '1180591620717411303424',
                'unit' => 'ZB',
                'rank' => '8'
            ),
            array(
                'minSize' => '1152921504606846976',
                'unit' => 'EB',
                'rank' => '7'
            ),
            array(
                'minSize' => '1125899906842624',
                'unit' => 'PB',
                'rank' => '6'
            ),
            array(
                'minSize' => '1099511627776',
                'unit' => 'TB',
                'rank' => '5'
            ),
            array(
                'minSize' => '1073741824',
                'unit' => 'GB',
                'rank' => '4'
            ),
            array(
                'minSize' => '1048576',
                'unit' => 'MB',
                'rank' => '3'
            ),
            array(
                'minSize' => '1024',
                'unit' => 'KB',
                'rank' => '2'
            ),
            array(
                'minSize' => '0',
                'unit' => 'B',
                'rank' => '1'
            )
            
        );
    }
    
    
    
    function fileSizeByFileName($fileName, $roundOff = '2'){
        $fileSize = filesize($fileName);
        foreach($this->size as $key => $result){
            if( $fileSize >= $result['minSize'] ){
                $requiredUnitRank = $result['rank'];
                $requiredUnit = $result['unit'];
                $requiredMinSize = $result['minSize'];
                break;
            }
        }
        
        $finalSize = number_format( ( $fileSize / $requiredMinSize ),$roundOff );
        
        return $finalSize.' '.$requiredUnit;
        
    }
    
    
    
    function fileSizeConversion($fileSize, $currentUnit = 'B', $requiredUnit = '', $roundOff = '2'){
        foreach($this->size as $key => $result){
            if(  $result['unit'] ==  strtoupper($currentUnit) ){
                $currentUnitRank = $result['rank'];
                $currentMinSize = $result['minSize'];
            }
        }
        if($requiredUnit == ''){
            foreach($this->size as $key => $result){
                if( $fileSize >= $result['minSize'] ){
                    $requiredUnitRank = $result['rank'];
                    $requiredUnit = $result['unit'];
                    $requiredMinSize = $result['minSize'];
                    break;
                }
            }
        } else {
            foreach($this->size as $key => $result){
                if(  $result['unit'] ==  strtoupper($requiredUnit) ){
                    $requiredUnitRank = $result['rank'];
                    $requiredUnit = $result['unit'];
                    $requiredMinSize = $result['minSize'];
                }
            }
        }
        
        if($requiredUnitRank > $currentUnitRank){
            
            $diffRank = $requiredUnitRank - $currentUnitRank;
            $calculationSize = ( $currentMinSize == 0) ? 1 : $currentMinSize ;
            for($start = 1; $start <= $diffRank; $start++)
            $calculationSize = $calculationSize * 1024;
            
            $finalSize = number_format( ( $fileSize / $calculationSize ),$roundOff );
            
        } elseif ($requiredUnitRank < $currentUnitRank){
            
            $finalSize = number_format( ( ($fileSize * $currentMinSize) /  $requiredMinSize),$roundOff );
            
        } else {
            
            $finalSize = $fileSize;
        }
        
       return $finalSize.' '.$requiredUnit;
    }
};