<?php
/***************************************************************************
 *                              sun_class.php
 *                       -------------------
 *   last modification    : 27.10.2005
 *   copyright            : (C) 2005 radzio
 *   email                : radziupiekarz@poczta.fm
 *
 *
 *
 ***************************************************************************/

/***************************************************************************
 * This class calculates sunrise and sunset.
 * This script includes is_daylight_time() function from Steve Edberg
 * and perl code translated from the perl module Astro-SunTime-0.01.
 * 
 * 
 *
 *
 *
 *
 ***************************************************************************/

class sun
{
	var $latitude;     #szerokosc geograficzna
	var $longitude;    #dlugosc geograficzna
	var $timezone;     #strefa czasowa
		function sun ($latitude, $longitude, $timezone)
			{
				$this->latitude = $latitude;
				$this->longitude = $longitude;
				$this->timezone = $timezone;
				$this->yday = date("z");
                $this->mon = date("n");
                $this->mday = date("j");
                $this->year = date("Y");
                #---------------------
                $this->DST=$this->is_daylight_time(date("U"));
                    if ($this->DST)
	                   {
		                  $this->timezone = ($this->timezone + 1);
	                   }
                    if ($this->timezone == "13")
	                   {
		                  $this->timezone = "-11";
	                   }
                #---------------------
                $this->A = 1.5708;
                $this->B = 3.14159;
                $this->C = 4.71239;
                $this->D = 6.28319;
                $this->E = 0.0174533 * $this->latitude;
                $this->F = 0.0174533 * $this->longitude;
                $this->G = 0.261799  * $this->timezone;
                #---------------------
                  # For astronomical twilight, use
                  #$this->R = -.309017;
                  # For     nautical twilight, use
                  #$this->R = -.207912;
                  # For        civil twilight, use
                  #$this->R = -.104528;
                  # For     sunrise or sunset, use
                  $this->R = -.0145439;
                #---------------------
                
			}
        function is_daylight_time($time)
            {
	           list($dom, $dow, $month, $hour, $min) = explode(":", date("d:w:m:H:i", $time));
	           if   ($month > 4 && $month < 10)
		          {
  			           $this->retval = 1;        # May thru September
		          }
	           elseif ($month == 4 && $dom > 7)
		          {
  			           $this->retval = 1;        # After first week in April
		          }
	           elseif ($month == 4 && $dom <= 7 && $dow == 0 && $hour >= 2)
		          {
  			           $this->retval = 1;        # After 2am on first Sunday ($dow=0) in April
		          }
	           elseif ($month == 4 && $dom <= 7 && $dow != 0 && ($dom-$dow > 0))
		          {
  			           $this->retval = 1;        # After Sunday of first week in April
		          }
	           elseif ($month == 10 && $dom < 25)
		          {
  			           $this->retval = 1;        # Before last week of October
		          }
	           elseif ($month == 10 && $dom >= 25 && $dow == 0 && $hour < 2)
		          {
  			           $this->retval = 1;        # Before 2am on last Sunday in October
		          }
	           elseif ($month == 10 && $dom >= 25 && $dow != 0 && ($dom-24-$dow < 1) )
		          {
  			           $this->retval = 1;        # Before Sunday of last week in October
		          }
	           else
		          {
  			           $this->retval = 0;
		          }

                  

                return $this->retval;
        }
    function sunrise()
        {
            $J =  $this->A;
            $K = $this->yday + (($J - $this->F) / $this->D);
            $L = ($K * .017202) - .0574039;              # Solar Mean Anomoly
            $M = $L + .0334405 * sin($L);                # Solar True Longitude
            $M += 4.93289 + (3.49066E-04) * sin(2 * $L);
                if ($this->D == 0)
		          {
			         echo "Trying to normalize with zero offset..."; exit;
		          }
                while ($M < 0)
		          {
			         $M = ($M + $this->D);
		          }
                while ($M >= $this->D)
		          {
			         $M = ($M - $this->D);
		          }
                if (($M / $this->A) - intval($M / $this->A) == 0)
		          {
			         $M += 4.84814E-06;
		          }
            $P = sin($M) / cos($M);                   # Solar Right Ascension
            $P = atan2(.91746 * $P, 1);
            # Quadrant Adjustment
                if ($M > $this->C)
		          {
			         $P += $this->D;
		          }
                else
		          {
			         if ($M > $this->A)
				        {
	                       $P += $this->B;
                        }
		          }

            $Q = .39782 * sin($M);            # Solar Declination
            $Q = $Q / sqrt(-$Q * $Q + 1);     # This is how the original author wrote it!
            $Q = atan2($Q, 1);
            $S = $this->R - (sin($Q) * sin($this->E));
            $S = $S / (cos($Q) * cos($this->E));
                if (abs($S) > 1)
                    {
                        echo 'none';
                    }     # Null phenomenon
            $S = $S / sqrt(-$S * $S + 1);
            $S = $this->A - atan2($S, 1);
            $S = $this->D - $S ;
            $T = $S + $P - 0.0172028 * $K - 1.73364; # Local apparent time
            $U = $T - $this->F;                            # Universal timer
            $V = $U + $this->G;                            # Wall clock time
            # Quadrant Determination
                if ($this->D == 0)
                    {
                        echo "Trying to normalize with zero offset..."; exit;
                    }
                while ($V < 0)
                    {
                        $V = ($V + $this->D);
                    }
                while ($V >= $this->D)
                    {
                        $V = ($V - $this->D);
                    }
            $V = $V * 3.81972;
            $hour = intval($V);
            $min  = intval((($V - $hour) * 60) + 0.5);
            echo date( "G:i ", mktime($hour,$min,0,$this->mon,$this->mday,$this->year) );

        }
    function sunset()
        {
            $J =  $this->C;
            $K = $this->yday + (($J - $this->F) / $this->D);
            $L = ($K * .017202) - .0574039;              # Solar Mean Anomoly
            $M = $L + .0334405 * sin($L);                # Solar True Longitude
            $M += 4.93289 + (3.49066E-04) * sin(2 * $L);
                if ($this->D == 0)
		          {
			         echo "Trying to normalize with zero offset..."; exit;
		          }
                while ($M < 0)
		          {
			         $M = ($M + $this->D);
		          }
                while ($M >= $this->D)
		          {
			         $M = ($M - $this->D);
		          }
                if (($M / $this->A) - intval($M / $this->A) == 0)
		          {
			         $M += 4.84814E-06;
		          }
            $P = sin($M) / cos($M);                   # Solar Right Ascension
            $P = atan2(.91746 * $P, 1);
            # Quadrant Adjustment
                if ($M > $this->C)
		          {
			         $P += $this->D;
		          }
                else
		          {
			         if ($M > $this->A)
				        {
	                       $P += $this->B;
                        }
		          }

            $Q = .39782 * sin($M);            # Solar Declination
            $Q = $Q / sqrt(-$Q * $Q + 1);     # This is how the original author wrote it!
            $Q = atan2($Q, 1);
            $S = $this->R - (sin($Q) * sin($this->E));
            $S = $S / (cos($Q) * cos($this->E));
                if (abs($S) > 1)
                    {
                        echo 'none';
                    }     # Null phenomenon
            $S = $S / sqrt(-$S * $S + 1);
            $S = $this->A - atan2($S, 1);
            #$S = $this->D - $S ;
            $T = $S + $P - 0.0172028 * $K - 1.73364; # Local apparent time
            $U = $T - $this->F;                            # Universal timer
            $V = $U + $this->G;                            # Wall clock time
            # Quadrant Determination
                if ($this->D == 0)
                    {
                        echo "Trying to normalize with zero offset..."; exit;
                    }
                while ($V < 0)
                    {
                        $V = ($V + $this->D);
                    }
                while ($V >= $this->D)
                    {
                        $V = ($V - $this->D);
                    }
            $V = $V * 3.81972;
            $hour = intval($V);
            $min  = intval((($V - $hour) * 60) + 0.5);
            echo date( "G:i ", mktime($hour,$min,0,$this->mon,$this->mday,$this->year) );
        }

}
?>
