<?
class pHoliday {

	//   PHOLIDAY CLASS
	//   --------------
	//   Author  : Copyright Pierre FAUQUE, pierre@fauque.net, 25/03/2006.
	//   Usage   : Calculate the dates of religious public holidays
	//   Version : 1.0
	//
	//   <DELETE>
	//   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	//   DOCUMENTATION
	//   -------------
	//   All religious public holidays are calculate from Easter.
	//   Easter is the first sunday after the full moon which arrives on
	//   the spring equinox or the following days.
	//   Easter is between march 22th and april 25th.
	//   Other public holidays are a number of days less or more than Easter.
	//
	//   Class verified from 1900 up to 2099
	//
	//   Franais     |  English         |  to get the date, use the method
	// ---------------+------------------+-----------------------------------
	//   Pques       |  Easter          |  paques()
	//   Cendres      |  Ash             |  cendres()
	//   Carme       |  Lent            |  careme()
	//   Ascension    |  Ascension       |  ascension()
	//   Pentecte    |  Whitsun         |  pentecote()
	//   Trinit      |  Trinity         |  trinite()
	//   Fte-Dieu    |  Corpus Christi  |  fetedieu()
	//   Sacr-Coeur  |  Sacred Heart    |  sacrecoeur()
	//
	//   If you want change the date format, see the format in use with the
	//   PHP function date() and modify the $fmt attribute.
	//
	//   EXAMPLE:
	//
	//   $year = new pHoliday(2006);
	//   echo "Whitsun arrives on ".$year->pentecote();
	//
	//   All lines between <DELETE> and </DELETE>can be deleted (these tags included)
	//   when they are read.
	//   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	//   </DELETE>

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// ATTRIBUTES OF THE CLASS

	var $ref = 0;        // Date of Easter
	var $fmt = "d/m/Y";  // Date format.

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Constructor. If no date is provided, the current year will be used
	function pHoliday ($an=0) {
		if($an) { $this->calcref($an); }
		else    { $this->calcref(date("Y")); }
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// This function calculate the date of Easter (reference)
	function calcref($an) {
		$a = $an%19; $b = $an%4; $c = $an%7;
		$d = ((19*$a)+24)%30;
		$e = ((2*$b)+(4*$c)+(6*$d)+5)%7;
		$p = (22+$d+$e);
		$this->ref = mktime(0,0,0,3,$p,$an); // Easter
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Return the number of seconds for a number of day
	function days($nb)    { return $nb * 86400; }

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// All methods return the date of each public holiday in the defined format
	function paques()     { return date("$this->fmt",$this->ref); }
	function cendres()    { return date("$this->fmt",$this->ref-$this->days(45)); }
	function careme()     { return date("$this->fmt",$this->ref-$this->days(41)); }
	function ascension()  { return date("$this->fmt",$this->ref+$this->days(39)); }
	function pentecote()  { return date("$this->fmt",$this->ref+$this->days(49)); }
	function trinite()    { return date("$this->fmt",$this->ref+$this->days(56)); }
	function fetedieu()   { return date("$this->fmt",$this->ref+$this->days(63)); }
	function sacrecoeur() { return date("$this->fmt",$this->ref+$this->days(68)); }
}
?>