using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace CustomControl
{
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:WebCustomControl runat=server></{0}:WebCustomControl>")]
    public class WebCustomControl : WebControl
    {
        [Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Text
        {
            get
            {
                String s = (String)ViewState["Text"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["Text"] = value;
            }
        }

        [Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Text2
        {
            get
            {
                String s = (String)ViewState["Text2"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["Text2"] = value;
            }
        }



        protected override void RenderContents(HtmlTextWriter output)
        {
            output.Write(Text);
            output.Write("<br/>");
            output.Write(Text2);
            output.Write("<br/>");
        }

        protected override void OnInit(EventArgs e)
        {
            Page.RegisterRequiresControlState(this);
            base.OnInit(e);
        }

        protected override void LoadControlState(object savedState)
        {
            Text = (string)savedState;
        }

        protected override object SaveControlState()
        {
            return Text;
        }
    }
}
