/*
 * metrodesktopjs - Metro Style Desktop jQuery Plugin
 *
 * Version: 0.1  2012-03-11
 *
 * Copyright (c) 2012 Yusuf Akyol Istanbul,TURKEY
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * http://yusufakyol.com/ItemDetail.php?locale=en&id=19
 * 
 *
 */
;(function($) {  
  $.fn.metrodesktop = function(options) {

	var defaults = { 
		mdouterdiv: ".metrodesktop",
		mdrow: 5,
		mdcol: 3,
		mdlogoheight: 6.5,
		mdgutter: 2,		
		mdcookiename: "metrodesktop",
		mdallclasses: "metrobox"	
	}
	var options = $.extend(defaults, options);

	var outerdiv = options.mdouterdiv;
	var row = options.mdrow;
	var col = options.mdcol;
	var logoheight = options.mdlogoheight;
	var gutter = options.mdgutter;	
	var cookiename = options.mdcookiename;	
	var allclasses = options.mdallclasses;			
	var boxwidth = 10;
	var boxheight = 6;
	var boxmargin = 0.5;
	var boxpadding = 0.5;	
	var cols = new Array(col);
	var colindx = 0;
	var boxnum = 0;
	var boxid = '';
	var boxseq = '';	
	var metrosq = 'metrosq';

	function getItems(container) {	
		var columns = [];
		$(container+ ' div.metroblock').each(function(){
			columns.push($(this).sortable('toArray').join(','));
		});
		return columns.join('|');		
	}

	function collectMenus() {
		var menuid = '';
		var menusq = 0;
		$(outerdiv+' ul li ul').each(function(inx, el) {
			menuid = 'metromenu'+menusq;
			$(el).parent().attr('rel', menuid);
			$(el).addClass(menuid);
			$(el).appendTo('body');
			$(el).removeClass('metromenu');
			$(el).wrap('<div id="'+menuid+'" class="metromenu" />');
			menusq += 1;
		});	
		$('.metromenu').hide();
	}

	function displayMenu(menudetail) {
		$.fancybox(menudetail, {minWidth:400, minHeight:500, maxWidth:400, maxHeight:500, margin:[100,100,100,100], openOpacity:false, closeOpacity: false, helpers:{overlay:null}});
	}
	
	function setMenus() {
		$(outerdiv+' div').each(function(inx, el) {
			if ($(el).attr('rel')) {
				var divid = $(el).attr('rel');
				if (divid.indexOf('metromenu') == 0) {
					$(el).click(function() {
						displayMenu($('#'+divid).html());
					});
				}
			}
		});
	}
	
	function findOwnerBlock(items, inx) {
		var elpos = new Array();
		var elem = '';
		var bid = metrosq+inx; 
		var blockid = '';
		var br = false;
		var columns = items.split('|');	
		m = 0;
		for (var c in columns) {
			m += 1;
			blockid = 'metrobox'+m;
			if (columns[c] != '') { 
				var colitems = columns[c].split(',');
				elem = '';
				for (var i in colitems) {
					if (bid == colitems[i]) {
						br = true;
						elpos[0] = i;
						break;
					}
					if (elem > '') {
						i1 = colitems[i].split(metrosq);
						i2 = elem.split(metrosq);
						if (elem == '' || inx > i1[1])						
							elem = colitems[i];						
					} else {
						elem = colitems[i];
					}
				}
			}
			if (br) break;
		}

		elpos[1] = elem;
		elpos[2] = blockid;
		return elpos;
	}
	
	function sortItems(items, container) {
		var totitems = 0;
		var columns = items.split('|');
		for (var c in columns) {
			if (columns[c] != '') {
				var colitems = columns[c].split(','); 
				totitems += colitems.length;
			}
		}					
		if (totitems != $(outerdiv+' li').length) {
			createDefault();
		} else {
			for (var c in columns) {
				boxnum += 1;
				boxid = 'metrobox'+boxnum;
				$('<div></div>').attr('id', boxid).addClass('metroblock').appendTo(outerdiv);
			}	
			
			$(outerdiv+' ul > li').not(outerdiv+' ul li ul li').each(function(inx, el) {
				var classList = '';
				var boxrow = 0;
				var boxcol = 0;
				var divw = '';
				var divh = '';
				var divstyle = '';
				var divrel = '';
				
				allclasses = 'metrobox';
				if ($(this).attr('class'))
					var classList = $(this).attr('class').split(/\s+/);
				if (classList.length > 0) {
					$.each(classList, function(index, item) {
						if (item.length == 10 && item.substr(0,8) == 'metrobox') {
							boxrow = parseInt(item.substr(8,1));
							boxcol = parseInt(item.substr(9,1));
						}
						allclasses += ' '+item;
					});
					$(this).removeAttr('class');
				}
				
				if (boxrow > row)
					boxrow = row;
					
				if (boxcol > col)
					boxcol = col;
					
				if (boxcol > 1) {
					boxNewWidth = ((boxwidth + boxmargin + boxpadding) * boxcol) + ((boxmargin + boxpadding) * (boxcol - 2));
					divw = ' width:'+boxNewWidth+'em;';
				} else {
					boxcol = 1;
				}
					
				if (boxrow > 1) {
					boxNewHeight = ((boxheight + boxmargin + boxpadding) * boxrow) + ((boxmargin + boxpadding) * (boxrow - 2));
					divh = ' height:'+boxNewHeight+'em;';
				} else {
					boxrow = 1;
				}
		
				if (divw > ' ' || divh > ' ')
					divstyle = ' style="' + divw + divh +'" ';
					
				if ($(this).attr('rel')) 
					divrel = ' rel="'+$(this).attr('rel')+'"';

				$(this).wrapInner('<div class="'+allclasses+'" '+divstyle+' id="'+metrosq+inx+'"'+divrel+' />');	
				
				eldata = $(el).html();
				boxid = findOwnerBlock(items, inx);
				cnt = $('#'+boxid[2]+' div').length;
				if (cnt == 0)
					$(eldata).appendTo($('#'+boxid[2]));
				else if (boxid[0] == 0)
					$(eldata).prependTo($('#'+boxid[2]));
				else
					$('#'+boxid[1]).after(eldata);
				$(el).remove();				
			});
		}
	}
	
	function createDefault() {
		boxnum += 1;
		boxid = 'metrobox'+boxnum;
		$('<div></div>').attr('id', boxid).addClass('metroblock').appendTo(outerdiv);
			
		$(outerdiv+' ul > li').not(outerdiv+' ul li ul li').each(function(inx, el) {
			var classList = '';
			var boxrow = 0;
			var boxcol = 0;
			var divw = '';
			var divh = '';
			var divstyle = '';
			var divrel = '';
			
			allclasses = 'metrobox';
			if ($(this).attr('class'))
				var classList = $(this).attr('class').split(/\s+/);
			if (classList.length > 0) {
				$.each(classList, function(index, item) {
					if (item.length == 10 && item.substr(0,8) == 'metrobox') {
						boxrow = parseInt(item.substr(8,1));
						boxcol = parseInt(item.substr(9,1));
					}
					allclasses += ' '+item;
				});
				$(this).removeAttr('class');
			}
			
			if (boxrow > row)
				boxrow = row;
				
			if (boxcol > col)
				boxcol = col;
				
			if (boxcol > 1) {
				boxNewWidth = ((boxwidth + boxmargin + boxpadding) * boxcol) + ((boxmargin + boxpadding) * (boxcol - 2));
				divw = ' width:'+boxNewWidth+'em;';
			} else {
				boxcol = 1;
			}
				
			if (boxrow > 1) {
				boxNewHeight = ((boxheight + boxmargin + boxpadding) * boxrow) + ((boxmargin + boxpadding) * (boxrow - 2));
				divh = ' height:'+boxNewHeight+'em;';
			} else {
				boxrow = 1;
			}
			
			if (divw > ' ' || divh > ' ')
				divstyle = ' style="' + divw + divh +'" ';
				
			if ($(this).attr('rel')) 
				divrel = ' rel="'+$(this).attr('rel')+'"';

			$(this).wrapInner('<div class="'+allclasses+'" '+divstyle+' id="'+metrosq+inx+'"'+divrel+' />');	
			
			var min = 0;
			for (i=0; i<col; i++) {
				if (cols[i] < cols[min])
					min = i;
			}
			
			if ((min + boxcol) > col) {
				min = 0;
			}
			
			if (((min + boxcol) > col) || ((cols[min] + boxrow) > row)) {
				for (i=0; i<col; i++) {
					cols[i] = 0;
				}	
				min = 0;
				boxnum += 1;
				boxid = 'metrobox'+boxnum;
				$('<div></div>').attr('id', boxid).addClass('metroblock').appendTo(outerdiv);			
			}	
			cols[min] = cols[min] + boxrow;
			for (i=0; i<min; i++) {
				if (cols[i] < cols[min]) {
					cols[i] = cols[min];
				}				
			}				
			eldata = $(el).html();
			$(eldata).appendTo($('#'+boxid));
			$(el).remove();		
			if (boxcol > 1) {
				for (i=1; i<boxcol; i++) {
					cols[min+i] = cols[min];
				}		
			}
		});
		
		/* one extra block added */
		boxnum += 1;
		boxid = 'metrobox'+boxnum;
		$('<div><div class="dummy"></div></div>').attr('id', boxid).addClass('metroblock').appendTo(outerdiv);	
	}

	var winw = $(window).width();
	var winh = $(window).height();
	$('#logo img').css('width', winw);
	$('#logo img').css('height', logoheight+'em');
	
	$('<div></div>').addClass('metrobox').attr('id','delit').appendTo(outerdiv);
	var fontsz = parseFloat($('#delit').css('font-size'));
	var boxwidth = parseFloat($('#delit').width()) / fontsz;
	var boxheight = parseFloat($('#delit').height()) / fontsz;
	var boxmargin = ((parseFloat($('#delit').outerWidth(true)) / fontsz) - (parseFloat($('#delit').width()) / fontsz )) / 2;
	var boxpadding = 0;	
	$('#delit').removeClass('metrobox').addClass('metroblock');
	gutter = parseFloat($('#delit').css('margin-right')) / fontsz;
	$('#delit').remove();
	
	for (i=0; i<col; i++) {
		cols[i] = 0;
	}
		
	$(outerdiv).css('visibility', 'hidden');

	collectMenus();
	
    if ($.cookie(cookiename) != null) {
        sortItems($.cookie(cookiename), outerdiv);		
    } else {
		createDefault();
	}
	
	$(outerdiv).find('ul').remove();
	
	var blockw = (boxwidth + ((boxmargin + boxpadding) * 2)) * col + 0.5; /* 0.5 added for ie9 */
	var viewportw = (blockw + gutter) * boxnum;	
	var viewporth = (winh /fontsz) - logoheight - 0.3;
	$('.horizontal-only').css('height', viewporth+'em');	
	$('.metroblock').css('width', blockw+'em');	
	$(outerdiv).css('width', viewportw+'em');
	
	$('.scroll-pane').jScrollPane();
	$('.scroll-pane-arrows').jScrollPane(
		{
			enableKeyboardNavigation: true,
			horizontalGutter: 10
		}
	);
	$('.scroll-pane').focus();	
	
	setMenus();
	
	$(outerdiv).css('visibility', 'visible');	

	$('.metrodesktop .metroblock').sortable({
		connectWith: '.metrodesktop .metroblock',
		containment: '.scroll-pane',
		update: function(){
			$.cookie(cookiename, getItems(outerdiv));
		}		
	});	

	shortcut.add("Ctrl+F5",function() {	
		$.cookie(cookiename,'');
		window.location.reload();	
	});
  }
})(jQuery);