﻿Public Class HomeController
    Inherits System.Web.Mvc.Controller


    Function GetCaptcha() As ActionResult
        'Captcha Image Size  Width - Height
        Dim width As Integer = 75
        Dim height As Integer = 20


        'Captcha String
        Dim fontFamily = "Tahoma"
        ' -  Generate Random 
        Dim randomsize As Integer = 5
        Dim randomstringbuilder As New StringBuilder()
        Dim random As New Random(DateTime.Now.Millisecond)
        Dim ch As Char
        For i As Integer = 0 To randomsize - 1
            ch = Convert.ToChar(Convert.ToInt32(Math.Floor(26 * random.NextDouble() + 65)))
            randomstringbuilder.Append(ch)
        Next
        Dim captchaString = generateRandomNumber(3)

        ' Create a new 32-bit bitmap image.
        Dim bitmap As New Drawing.Bitmap(width, height, Drawing.Imaging.PixelFormat.Format32bppArgb)

        ' Create a graphics object for drawing.
        Dim g As Drawing.Graphics = Drawing.Graphics.FromImage(bitmap)
        g.SmoothingMode = Drawing.Drawing2D.SmoothingMode.AntiAlias
        Dim rect As New Drawing.Rectangle(0, 0, width, height)

        ' Fill in the background.
        Dim hatchBrush As New Drawing.Drawing2D.HatchBrush(Drawing.Drawing2D.HatchStyle.Wave, Drawing.Color.LightGray, Drawing.Color.White)
        g.FillRectangle(hatchBrush, rect)

        ' Set up the text font.
        Dim size As Drawing.SizeF
        Dim fontSize As Single = rect.Height + 1
        Dim font As Drawing.Font
        Dim format As New Drawing.StringFormat()
        format.Alignment = Drawing.StringAlignment.Center
        format.LineAlignment = Drawing.StringAlignment.Center

        ' Adjust the font size until the text fits within the image.
        Do
            fontSize -= 1
            font = New Drawing.Font(fontFamily, fontSize, Drawing.FontStyle.Bold)
            size = g.MeasureString(captchaString, font, New Drawing.SizeF(width, height), format)
        Loop While size.Width > rect.Width

        ' Create a path using the text and warp it randomly.
        Dim path As New Drawing.Drawing2D.GraphicsPath()
        path.AddString(captchaString, font.FontFamily, CInt(font.Style), font.Size, rect, format)
        Dim v As Single = 4.0F
        Dim points As Drawing.PointF() = {New Drawing.PointF(random.[Next](rect.Width) / v, random.[Next](rect.Height) / v), New Drawing.PointF(rect.Width - random.[Next](rect.Width) / v, random.[Next](rect.Height) / v), New Drawing.PointF(random.[Next](rect.Width) / v, rect.Height - random.[Next](rect.Height) / v), New Drawing.PointF(rect.Width - random.[Next](rect.Width) / v, rect.Height - random.[Next](rect.Height) / v)}
        Dim matrix As New Drawing.Drawing2D.Matrix()
        matrix.Translate(0.0F, 0.0F)
        path.Warp(points, rect, matrix, Drawing.Drawing2D.WarpMode.Perspective, 0.0F)

        ' Draw the text.
        hatchBrush = New Drawing.Drawing2D.HatchBrush(Drawing.Drawing2D.HatchStyle.DashedUpwardDiagonal, Drawing.Color.DarkGray, Drawing.Color.Black)
        g.FillPath(hatchBrush, path)

        ' Add some random noise.
        Dim m As Integer = Math.Max(rect.Width, rect.Height)
        For i As Integer = 0 To CInt(Math.Truncate(rect.Width * rect.Height / 30.0F)) - 1
            Dim x As Integer = random.[Next](rect.Width)
            Dim y As Integer = random.[Next](rect.Height)
            Dim w As Integer = random.[Next](m \ 50)
            Dim h As Integer = random.[Next](m \ 50)
            g.FillEllipse(hatchBrush, x, y, w, h)
        Next


        ' Clean up.
        font.Dispose()
        hatchBrush.Dispose()
        g.Dispose()

        Dim captchaImageResult As FileContentResult = Nothing
        Using mystream As New System.IO.MemoryStream()

            bitmap.Save(mystream, System.Drawing.Imaging.ImageFormat.Jpeg)
            captchaImageResult = MyBase.File(mystream.GetBuffer, "image/jpeg")

        End Using
        bitmap.Dispose()




        'Save the Captcha Hash in the Session
        Session("botdeflector") = Convert.ToBase64String(System.Security.Cryptography.MD5.Create().ComputeHash(Encoding.UTF8.GetBytes(captchaString)))

        'Return the Captcha Image
        Return captchaImageResult

    End Function

    Function Index() As ActionResult
        ViewData("Message") = "Welcome to ASP.NET MVC!"

        Return View()
    End Function



    <HttpPost()>
    Function index(CaptchaAnswer As String) As ActionResult

        Dim captchaHash = Session("botdeflector")

        If captchaHash = Convert.ToBase64String(System.Security.Cryptography.MD5.Create().ComputeHash(Encoding.UTF8.GetBytes(UCase(CaptchaAnswer)))) Then

            'Valid
            ViewData("Message") = "YOU ARE A PERSON :>"


        Else
            'In valid
            ViewData("Message") = "YOU ARE A ROBOT!"

        End If


        Return View()


    End Function

    Function About() As ActionResult
        Return View()
    End Function


    Private Function generateRandomString(ByVal size As Integer) As String

        Dim builder As New StringBuilder()
        Dim random As New Random(DateTime.Now.Millisecond)
        Dim ch As Char
        For i As Integer = 0 To size - 1
            ch = Convert.ToChar(Convert.ToInt32(Math.Floor(26 * random.NextDouble() + 65)))
            builder.Append(ch)
        Next
        Return builder.ToString()

    End Function

    Private Function generateRandomNumber(ByVal size As Integer) As String

        Dim builder As New StringBuilder()
        Dim random As New Random(DateTime.Now.Millisecond)
        Dim ch As Char
        For i As Integer = 0 To size - 1
            ch = random.Next(9).ToString
            builder.Append(ch)
        Next
        Return builder.ToString()

    End Function


End Class
