﻿using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.Web.Routing;

namespace System.Web.Mvc.Html
{
    /// <summary>
    /// Modified Copy of Microsofts MVC2 Form Extensions
    /// The major addition was adding the view page parameter. You have to know what the controler is so you can figure everything else out.
    /// </summary>
    public static class FormExtensions
    {
        public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId)
        {
            // generates <form action="{current url}" method="post">...</form> 
            string formAction = CookielessHelper.GetSessionEnabledURL(htmlHelper.ViewContext.RouteData.Values["Controller"].ToString() , true);

            return FormHelper(htmlHelper,formId, formAction, FormMethod.Post, new RouteValueDictionary());
        }

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, object routeValues)
        //{
        //    return BeginFormNoCookies(htmlHelper,formId, null, null, new RouteValueDictionary(routeValues), FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, RouteValueDictionary routeValues)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, null, null, routeValues, FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, new RouteValueDictionary(), FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, object routeValues)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, new RouteValueDictionary(routeValues), FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, RouteValueDictionary routeValues)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, routeValues, FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, FormMethod method)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, new RouteValueDictionary(), method, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, object routeValues, FormMethod method)
        //{
        //    return BeginFormNoCookies(htmlHelper,  actionName,formId, controllerName, new RouteValueDictionary(routeValues), method, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, RouteValueDictionary routeValues, FormMethod method)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, routeValues, method, new RouteValueDictionary());
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, FormMethod method, object htmlAttributes)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, new RouteValueDictionary(), method, new RouteValueDictionary(htmlAttributes));
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, FormMethod method, IDictionary<string, object> htmlAttributes)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, new RouteValueDictionary(), method, htmlAttributes);
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, object routeValues, FormMethod method, object htmlAttributes)
        //{
        //    return BeginFormNoCookies(htmlHelper, formId, actionName, controllerName, new RouteValueDictionary(routeValues), method, new RouteValueDictionary(htmlAttributes));
        //}

        //public static MvcForm BeginFormNoCookies(this HtmlHelper htmlHelper, string formId, string actionName, string controllerName, RouteValueDictionary routeValues, FormMethod method, IDictionary<string, object> htmlAttributes)
        //{
        //    string formAction = UrlHelper.GenerateUrl(null /* routeName */, actionName, controllerName, routeValues, htmlHelper.RouteCollection, htmlHelper.ViewContext.RequestContext, true /* includeImplicitMvcValues */);
        //    return FormHelper(htmlHelper,formId, formAction, method, htmlAttributes);
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, object routeValues)
        //{
        //    return BeginRouteForm(htmlHelper, formId, null /* routeName */, new RouteValueDictionary(routeValues), FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, RouteValueDictionary routeValues)
        //{
        //    return BeginRouteForm(htmlHelper, formId, null /* routeName */, routeValues, FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, new RouteValueDictionary(), FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, object routeValues)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, new RouteValueDictionary(routeValues), FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, RouteValueDictionary routeValues)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, routeValues, FormMethod.Post, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, FormMethod method)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, new RouteValueDictionary(), method, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, object routeValues, FormMethod method)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, new RouteValueDictionary(routeValues), method, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, RouteValueDictionary routeValues, FormMethod method)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, routeValues, method, new RouteValueDictionary());
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, FormMethod method, object htmlAttributes)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, new RouteValueDictionary(), method, new RouteValueDictionary(htmlAttributes));
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, FormMethod method, IDictionary<string, object> htmlAttributes)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, new RouteValueDictionary(), method, htmlAttributes);
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, object routeValues, FormMethod method, object htmlAttributes)
        //{
        //    return BeginRouteForm(htmlHelper, formId, routeName, new RouteValueDictionary(routeValues), method, new RouteValueDictionary(htmlAttributes));
        //}

        //public static MvcForm BeginRouteForm(this HtmlHelper htmlHelper, string formId, string routeName, RouteValueDictionary routeValues, FormMethod method, IDictionary<string, object> htmlAttributes)
        //{
        //    string formAction = UrlHelper.GenerateUrl(routeName, null, null, routeValues, htmlHelper.RouteCollection, htmlHelper.ViewContext.RequestContext, false /* includeImplicitMvcValues */);
        //    return FormHelper(htmlHelper,formId, formAction, method, htmlAttributes);
        //}

        public static void EndForm(this HtmlHelper htmlHelper)
        {
            htmlHelper.ViewContext.Writer.Write("</form>");
            htmlHelper.ViewContext.OutputClientValidation();
        }

        private static MvcForm FormHelper(this HtmlHelper htmlHelper,string formId, string formAction, FormMethod method, IDictionary<string, object> htmlAttributes)
        {
            TagBuilder tagBuilder = new TagBuilder("form");
            tagBuilder.MergeAttributes(htmlAttributes);
            // action is implicitly generated, so htmlAttributes take precedence.
            tagBuilder.MergeAttribute("action", formAction);
            // method is an explicit parameter, so it takes precedence over the htmlAttributes.
            tagBuilder.MergeAttribute("method", HtmlHelper.GetFormMethodString(method), true);

            /*Since FormIdGenerator is an internal function, i dont have access to it so this is not supported and the form must be named*/
            if (htmlHelper.ViewContext.ClientValidationEnabled)
            {
                if (formId == string.Empty) throw new ArgumentException("The formId must be set when Client Validation is enabled. Autogeneration is not available.");
                // forms must have an ID for client validation 
                tagBuilder.GenerateId(formId);
            }            

            htmlHelper.ViewContext.Writer.Write(tagBuilder.ToString(TagRenderMode.StartTag));
            MvcForm theForm = new MvcForm(htmlHelper.ViewContext);

            if (htmlHelper.ViewContext.ClientValidationEnabled)
            {
                htmlHelper.ViewContext.FormContext.FormId = tagBuilder.Attributes["id"];
            }

            return theForm;
        }
    }
}
