﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace System.Web.Mvc.Html
{
    /// <summary>
    /// Functions that help out when a cookless sessions are enabled using MVC
    /// </summary>
    public static class CookielessHelper
    {
        /// <summary>
        /// Gets the url with the session id in it
        /// </summary>
        /// <param name="currentPage"></param>
        /// <returns></returns>
        public static string GetSessionEnabledURL(System.Web.Mvc.ViewPage currentPage, bool withQueryParameters)
        {
            return GetSessionEnabledURL(currentPage.ViewContext.RouteData.Values["Controller"].ToString(), withQueryParameters);
        }

        /// <summary>
        /// Gets the url with the session id in it.
        /// </summary>
        /// <param name="currentPage"></param>
        /// <returns></returns>
        public static string GetSessionEnabledURL(string controller,bool withQueryParameters)
        {
            return RootURLDirectory + GetURISessionID() + "/" + controller + GetTrailingPrameters(controller) + (withQueryParameters? GetQueryParameters() : string.Empty);
        }

        /// <summary>
        /// Gets the base url with the session id in it and nothing else.
        /// </summary>
        /// <param name="currentPage"></param>
        /// <returns></returns>
        public static string GetSessionEnabledURL()
        {
            return RootURLDirectory + GetURISessionID() + "/";
        }

        /// <summary>
        /// Gets the session ID in the format "(S(ID here))"
        /// </summary>
        /// <returns></returns>
        public static string GetURISessionID()
        { 
            return "(S(" + HttpContext.Current.Session.SessionID + "))";
        }

        /// <summary>
        /// Gets any prameters after the controller
        /// </summary>
        /// <param name="controller"></param>
        /// <returns></returns>
        private static string GetTrailingPrameters(string controller)
        {
            string scriptName = System.Web.HttpContext.Current.Request.ServerVariables["SCRIPT_NAME"];
            int nameStart = scriptName.IndexOf(controller) + controller.Length;

            if (nameStart == controller.Length - 1)
                return string.Empty; //There is nothing after the controller
            else
                return scriptName.Substring(nameStart, scriptName.Length - nameStart);
        }

        /// <summary>
        /// Gets the query parameters if available, returns an empty string other wise
        /// </summary>
        /// <returns></returns>
        private static string GetQueryParameters()
        {
            return HttpContext.Current.Request.ServerVariables["QUERY_STRING"] == string.Empty ? string.Empty : "?" + HttpContext.Current.Request.ServerVariables["QUERY_STRING"];
        }
        
        /// <summary>
        /// Gets the root directory. Supports virtual directories or subdirectories.
        /// </summary>
        private static string RootURLDirectory
        {
            get
            {
                string virtualPath = System.Web.HttpRuntime.AppDomainAppVirtualPath;

                //If it doesn't have a trailing slash then add it.
                if (virtualPath.LastIndexOf("/") + 1 != virtualPath.Length)
                    virtualPath += "/";

                return virtualPath;
            }
        }

    }
}
