﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;
using System.Web.UI;
using System.IO;

namespace JqueryController
{
    

   public class MvcControllerBase : Controller
    {

        private bool _IsPartialRendering = false;
        private StringBuilder _ResponseToRender = new StringBuilder();
        private Dictionary<string, string> _postParameters = new Dictionary<string, string>();
        private string strParameters = string.Empty;
        public MvcControllerBase() { }


        public Dictionary<string, string> PostParameter {
            get { return _postParameters; }
        }

        public StringBuilder ResponseToRender
        {
            get
            {
                return _ResponseToRender;
            }
        }

        public bool IsPartialRendering
        {
            get
            {
                return _IsPartialRendering;
            }
            set
            {
                _IsPartialRendering = value;
            }
        }

        public bool PanelRefresh { get; set; }


      
        private void PopulatePostParameters(string strParams)
        {
            try
            {

                string[] parameters = strParams.Split('&');
                for (int i = 0; i < parameters.Length; i++)
                {
                    if (string.IsNullOrEmpty(parameters[i]) == false)
                    {
                        int equalPosition = parameters[i].IndexOf("=");
                        this._postParameters.Add(parameters[i].Substring(0, equalPosition), parameters[i].Substring(equalPosition + 1));
                    }
                }
            }
            catch (Exception ex)
            {
                throw new FormatException("The parameters string is not in the correct format", ex);
            }


        }

        protected override void Initialize(System.Web.Routing.RequestContext requestContext)
        {
            base.Initialize(requestContext);
        }

        protected override void  OnActionExecuting(ActionExecutingContext filterContext)
        {

            IsPartialRendering = false;
            if (filterContext.HttpContext.Request.Form["__parameters"] != null)
            {
                IsPartialRendering = true;
                this.PopulatePostParameters(filterContext.HttpContext.Request.Form["__parameters"]);
            }           
            base.OnActionExecuting(filterContext);
       }

        public ActionResult RefreshJQueryPanel<T>(string JQueryPanelId, string UserViewControlPath, T model)
        {
            const string PREFIX = @"$(""[id$='_";
            const string SUFFIX = @"']"")";
            string Html = string.Empty;
            var vd = new ViewDataDictionary(this.ViewData);
            var vp = new ViewPage
            {
                ViewData = vd,
                ViewContext = new ViewContext(),
                Url = new UrlHelper(this.ControllerContext.RequestContext)
            };
            vp.ViewData.Model = model;
            ViewUserControl v = (ViewUserControl)vp.LoadControl(UserViewControlPath);
            vp.Controls.Add(v);
            var sb = new StringBuilder();
            using (var sw = new StringWriter(sb))
            {
                using (var tw = new HtmlTextWriter(sw))
                {
                    vp.RenderControl(tw);
                }
            }
            Html = sb.ToString();
            Html = Html.Replace("\\", "\\\\");
            Html = Html.Replace(Environment.NewLine, string.Empty);
            Html = Html.Replace(@"""", "\\\"");
            
            return this.Content(PREFIX + JQueryPanelId + SUFFIX + @".html(""" + Html + @""");");
        }



        public ActionResult RefreshJQueryPanel<T>(string JQueryPanelId, string UserViewControlPath, T model, string functionName, params string[] callBackParms)
        {
            const string PREFIX = @"$(""[id$='_";
            string SUFFIX = @"']"")";
            string Html = string.Empty;
             var sb = new StringBuilder();
            var vd = new ViewDataDictionary(this.ViewData);
            var vp = new ViewPage
            {
                ViewData = vd,
                ViewContext = new ViewContext(),
                Url = new UrlHelper(this.ControllerContext.RequestContext)
            };
            vp.ViewData.Model = model;
            ViewUserControl v = (ViewUserControl)vp.LoadControl(UserViewControlPath);
            vp.Controls.Add(v);
           
            using (var sw = new StringWriter(sb))
            {
                using (var tw = new HtmlTextWriter(sw))
                {
                    vp.RenderControl(tw);
                }
            }
            Html = sb.ToString();         
            Html = Html.Replace("\\", "\\\\");
            Html = Html.Replace(Environment.NewLine, string.Empty);
            Html = Html.Replace(@"""", "\\\"");
            return this.Content(PREFIX + JQueryPanelId + SUFFIX + @".html(""" + Html + @""");" + AddCallBack(functionName, callBackParms));
        }


        private string AddCallBack(string functionName, params string[] callBackParms)
        {
            StringBuilder ParamToJs = new StringBuilder();
            if (callBackParms.Length > 0)
            {
                foreach (string parm in callBackParms)
                {
                    ParamToJs.Append("'" + parm + "',");
                }
                ParamToJs.Remove(ParamToJs.Length - 1, 1);
            }
            return functionName + "(" + ParamToJs.ToString() + ");";           
        }
    }
}
