﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
<title>Base64 Image Loader</title>
<link rel="stylesheet"
        href="<%: Url.Content("~/Content/Styles/Site.css") %>" />
<script
    src="<%: Url.Content("~/Content/Scripts/jquery-1.6.1.min.js") %>"
    type="text/javascript">
</script>

<script language="javascript" type="text/javascript">
    var imageUrl
        = "<%: Url.Action("GetBase64Image", "Image") %>";
    var imgs = null;

    $(document).ready(function () {
        if ($.browser.msie) {
            var browserMsg
                 = "Your browser does not support Base64 image"
            $("#divBrowserInfo").html(browserMsg);

            $("#btnClearImage").attr("disabled", true);
            $("#btnLoadImage").attr("disabled", true);
        }

        var displayImage = function (base64Data) {
            var imag = "<img "
                     + "src='" + "data:image/jpg;base64,"
                     + base64Data + "'/>";

            $("#divImageHolder").html(imag)
        };

        $("#btnLoadImage").click(function () {
            if (imgs != null) {
                displayImage(imgs.base64imgage);
                return;
            }

            $.ajax({
                cache: false,
                type: "GET",
                url: imageUrl,
                contentType: 'application/json',
                dataType: "json",
                success: function (data) {
                    imgs = data;
                    displayImage(imgs.base64imgage);
                },
                error: function (xhr) {
                    alert("Error occurred while loading the image. "
                        + xhr.responseText);
                }
            });
        });

        $("#btnClearImage").click(function () {
            $("#divImageHolder").html("");
        });
    });
</script>
</head>

<body>
    <div id="divBrowserInfo"></div>
    <div id="divImageHolder"></div>
    <div>
        <button id="btnClearImage">
            Clear Image</button>
        <button id="btnLoadImage">
            Load Base64 Image</button>
    </div>
</body>
</html>
