﻿
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;

namespace MvcMusicStore.Models
{
    public class AlbumViewModel
    {
        [DisplayName("ID")]
        public int AlbumId { get; set; }

        [ScaffoldColumn(false)]
        public int? GenreId { get; set; }

        [DisplayName("Genre")]
        public string Genre { get; set; }

        [ScaffoldColumn(false)]
        public int? ArtistId { get; set; }

        [DisplayName("Artist")]
        public string Artist { get; set; }

        [ScaffoldColumn(false)]
        public string AlbumTitle { get; set; }

        [DisplayName("Price")]
        [DisplayFormat(DataFormatString = "{0:c}")] 
        public decimal AlbumPrice { get; set; }

    }
}