﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace MvcMusicStore.Models
{
    public class AlbumService
    {
        private MvcMusicStoreEntities _context;
        public AlbumService()
        {
            _context = new MvcMusicStoreEntities();
        }

        public IQueryable<AlbumViewModel> GetAlbumsView()
        {
            var query = from a in GetAlbums()
                        select new AlbumViewModel
                        {
                            AlbumId = a.AlbumId,
                            GenreId = a.GenreId,
                            Genre = a.Genre.Name,
                            ArtistId = a.ArtistId,
                            Artist = a.Artist.Name,
                            AlbumTitle = a.Title,
                            AlbumPrice = a.Price
                        };
            return query;
        }

        public AlbumViewModel FindAlbumView(int albumId)
        {
            return GetAlbumsView().Where(a => a.AlbumId == albumId).Single();
        }

        public IQueryable<Album> GetAlbums()
        {
            return _context.Albums;
        }

        public IQueryable<Genre> GetGenres()
        {
            return _context.Genres;
        }

        public IQueryable<Artist> GetArtists()
        {
            return _context.Artists;
        }

        public void Save()
        {
            _context.SaveChanges();
        }
    }
}