﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MvcMusicStore.Common;
using MvcMusicStore.Models;
using MvcContrib.UI.Grid;

namespace MvcMusicStore.Controllers
{
    public class AlbumController : Controller
    {
        private AlbumService _service;

        public AlbumController()
        {
            _service = new AlbumService();
        }

        public ActionResult Index(string searchWord, int? genreId, int? artistId, GridSortOptions gridSortOptions, int? page)
        {
            var pagedViewModel = new PagedViewModel<AlbumViewModel>
            {
                ViewData = ViewData,
                Query = _service.GetAlbumsView(),
                GridSortOptions = gridSortOptions,
                DefaultSortColumn = "AlbumId",
                Page = page,
                PageSize = 10,
            }
            .AddFilter("searchWord", searchWord, a => a.AlbumTitle.Contains(searchWord) || a.Artist.Contains(searchWord) || a.Genre.Contains(searchWord))
            .AddFilter("genreId", genreId, a => a.GenreId == genreId, _service.GetGenres(), "Name")
            .AddFilter("artistId", artistId, a => a.ArtistId == artistId, _service.GetArtists(), "Name")
            .Setup();

            return View(pagedViewModel);
        }

        public ActionResult Details(int id)
        {
            var viewModel = _service.FindAlbumView(id);
            ViewBag.RouteDicForList = Request.QueryString.ToRouteDic();
            return View(viewModel);
        }

    }
}
