Imports System.Data.SqlClient
Public Class ChatWelcome
        Inherits System.Web.UI.Page
        Protected WithEvents Button1 As System.Web.UI.WebControls.Button
        Protected WithEvents txtUsername As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtChatID As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtUserID As System.Web.UI.WebControls.TextBox
        Protected WithEvents btGo As System.Web.UI.WebControls.Button
        Protected WithEvents DataGrid1 As System.Web.UI.WebControls.DataGrid
        Protected WithEvents lblDescription As System.Web.UI.WebControls.Label
        Protected WithEvents lblWelcome As System.Web.UI.WebControls.Label
        Protected WithEvents txtDescription As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtFullname As System.Web.UI.WebControls.TextBox

        Dim objChatBLL As New Chat_BLL()

#Region " Web Form Designer Generated Code "

        'This call is required by the Web Form Designer.
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

        End Sub

        Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
                'CODEGEN: This method call is required by the Web Form Designer
                'Do not modify it using the code editor.
                InitializeComponent()
        End Sub

#End Region

        Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
                'Put user code to initialize the page here
                doSetScreenValues()

                'If the user just left a chat, remove him from the ChatUserListing
                objChatBLL.DeleteSession(Session.SessionID)


                If Not Page.IsPostBack Then
                        BindGrid()
                End If
        End Sub

        Private Sub doSetScreenValues()

                Dim strMessages As String
                Dim strUserName As String = ""
                Dim strFullName As String = ""
                Dim strUserID As String = "0" & Session("CurrentUser")
                Dim strFirstName As String = "Invalid"


                'If the user's session is timed out, send them to the login page.
                If Trim(strUserID) = "0" Then
                        Server.Transfer("default.aspx")
                End If


                Dim rdr As SqlDataReader = objChatBLL.get_UserInfo(strUserID)
                While rdr.Read
                        strUserName = rdr("UserName")
                        strFirstName = rdr("FirstName")
                        strFullName = rdr("FirstName") & " " & rdr("LastName")
                End While

                lblWelcome.Text = "Hello " & strFirstName & ", welcome to ChattyWays." ' Your Chat name is: " & strFullName
                txtUsername.Text = strUserName
                txtFullname.Text = strFullName
                txtUserID.Text = strUserID
                Session("UserID") = strUserID

        End Sub

        Private Sub btGo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btGo.Click
                AddChat(txtDescription.Text)
                doGoToMessagePage()
        End Sub



        Private Sub BindGrid(Optional ByVal strSortField As String = "")
                DataGrid1.DataSource = objChatBLL.GetChatSessions(strSortField)
                DataGrid1.DataBind()
        End Sub


        Private Sub DataGrid1_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DataGrid1.SelectedIndexChanged
                ' Get the ID and return it to the parent window
                Dim nRow As String = DataGrid1.SelectedIndex


                Dim xxx As String = (DataGrid1.SelectedItem.ItemIndex)


                Dim strReturnValue As String

                Dim sScript As String = ""
                Dim strChatID = DataGrid1.Items(nRow).Cells(2).Text
                Dim strColText = UCase(DataGrid1.Items(nRow).Cells(0).Text)


                Dim strColText1 = UCase(DataGrid1.Items(nRow).Cells(0).Text)

                txtChatID.Text = strChatID
                Session("ChatID") = strChatID
        End Sub


        Function doGoToMessagePage()

                If Double.Parse(Request.Browser.Version) > 5.01 Then
                        Response.Redirect("ChatIE/ChatIEFrame.aspx")
                Else
                        Response.Redirect("ChatNS/ChatNSFrame.htm")
                End If

        End Function


        Private Sub DataGrid1_CancelCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridCommandEventArgs) Handles DataGrid1.CancelCommand
                DataGrid1.EditItemIndex = -1
                BindGrid()
        End Sub

        Private Sub DataGrid1_PageIndexChanged(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs) Handles DataGrid1.PageIndexChanged
                DataGrid1.CurrentPageIndex = e.NewPageIndex
                BindGrid()
        End Sub

        Private Sub DataGrid1_SortCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridSortCommandEventArgs) Handles DataGrid1.SortCommand
                BindGrid(e.SortExpression)
        End Sub

        Private Sub AddChat(ByVal strChatDescription As String)
                Session("ChatID") = objChatBLL.AddNewChat(strChatDescription)
        End Sub

        Private Sub DataGrid1_JoinCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridCommandEventArgs) Handles DataGrid1.DeleteCommand
                Response.Write("Here")
        End Sub
End Class
