Imports System.Data.SqlClient

Public Class ChatIEMessages
        Inherits System.Web.UI.Page
        Protected WithEvents txtError As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtCurrentChatID As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtCurrentChatDesc As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtLastMessageID As System.Web.UI.WebControls.TextBox
        Protected WithEvents Form1 As System.Web.UI.HtmlControls.HtmlForm
        Protected WithEvents tblChatters As System.Web.UI.WebControls.Table
        Protected WithEvents txtSpeakerClass As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtSpeakerName As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtScreenName As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtMessageClass As System.Web.UI.WebControls.TextBox
        Protected WithEvents DataGrid1 As System.Web.UI.WebControls.DataGrid
        Protected WithEvents txtMessageColor As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtSpeakerColor As System.Web.UI.WebControls.TextBox
        Protected WithEvents tblNewMessages As System.Web.UI.WebControls.Table

#Region "Developer Credits"
        '=======================================================================================
        'AUTHOR                  : David Silverlight
        '
        'CLAIM TO FAME      : Head Geek at XMLPitstop.com and CoFounder of NonProfitWays.com
        '
        'EMAIL                      : HeadGeek@XMLPitstop.com
        '
        'SHAMELESS PLUG  :Yes I am a consultant who is always looking for cool projects.
        '
        'PHONE                    : (561) 212-5707  Coconut Grove, Florida
        '
        'COPYWRIGHT		: This demo is not copywrighted so feel free to use it however it may help you.  Credit is always appreciated,
        '                                  but not required.  I created it simply for the learning experience. If you have any suggestions on areas that 
        '                                  can be improved upon, please feel free to email me.  All credit for enhancements will be given to 
        '                                  those who suggest them.  Enjoy.
        '=======================================================================================
#End Region

#Region " Web Form Designer Generated Code "

        'This call is required by the Web Form Designer.
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

        End Sub

        Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
                'CODEGEN: This method call is required by the Web Form Designer
                'Do not modify it using the code editor.
                InitializeComponent()
        End Sub

#End Region

        'Define the Business Logic Object, which will contain all of the Data Access Methods
        Dim objChatBLL As New Chat_BLL()

        Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

                'Retrieve the UserID and ChatIDs from the Session Variables (return 0 if they are empty)
                Dim intChatID As Integer = IIf(Trim(Session("ChatID") = ""), 0, CInt(Session("ChatID")))
                Dim intUserID As Integer = IIf(Trim(Session("UserID") = ""), 0, CInt(Session("UserID")))


                'If the user is in the UserChat table, remove him.
                objChatBLL.RemoveUserFromChat(intChatID, intUserID)

                'Add user to the table containing users for this chat
                objChatBLL.AddUserToChat(intChatID, intUserID, Session.SessionID)

                txtCurrentChatID.Text = intChatID
                txtCurrentChatDesc.Text = objChatBLL.get_ChatDescription(intChatID)

                If Not Page.IsPostBack Then
                        txtSpeakerClass.Text = "SpeakerTextMedium"
                        txtMessageClass.Text = "MessageTextMedium"
                        txtScreenName.Text = "Bullet"
                End If

        End Sub



End Class
