Imports System.Data.SqlClient

Public Class ChatIEBottom
        Inherits System.Web.UI.Page
        Protected WithEvents btFakeRecieve As System.Web.UI.WebControls.Button
        Protected WithEvents btSend As System.Web.UI.WebControls.Button
        Protected WithEvents btSignOut As System.Web.UI.WebControls.Button
        Protected WithEvents txtSendMessage As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtUserID As System.Web.UI.WebControls.TextBox
        Protected WithEvents txtChatID As System.Web.UI.WebControls.TextBox
        Protected WithEvents Button1 As System.Web.UI.WebControls.Button
        Protected WithEvents tblNewMessages As System.Web.UI.WebControls.Table
        Protected WithEvents txtNameColor As System.Web.UI.WebControls.TextBox
        Protected WithEvents btRemove As System.Web.UI.WebControls.Button
        Protected WithEvents txtMessageColor As System.Web.UI.WebControls.TextBox


        Dim objChatBLL As New Chat_BLL()         'Define the Business Logic Object, which will contain all of the Data Access Methods
#Region "Developer Credits"
        '=======================================================================================
        'AUTHOR                  : David Silverlight
        '
        'CLAIM TO FAME      : Head Geek at XMLPitstop.com and CoFounder of NonProfitWays.com
        '
        'EMAIL                      : HeadGeek@XMLPitstop.com
        '
        'SHAMELESS PLUG  :Yes I am a consultant who is always looking for cool projects.
        '
        'PHONE                    : (561) 212-5707  Coconut Grove, Florida
        '
        'COPYWRIGHT		: This demo is not copywrighted so feel free to use it however it may help you.  Credit is always appreciated,
        '                                  but not required.  I created it simply for the learning experience. If you have any suggestions on areas that 
        '                                  can be improved upon, please feel free to email me.  All credit for enhancements will be given to 
        '                                  those who suggest them.  Enjoy.
        '=======================================================================================
#End Region

#Region " Web Form Designer Generated Code "

        'This call is required by the Web Form Designer.
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

        End Sub

        Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
                'CODEGEN: This method call is required by the Web Form Designer
                'Do not modify it using the code editor.
                InitializeComponent()
        End Sub

#End Region

        Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
                'Put user code to initialize the page here
                txtUserID.Text = Session("UserID")
                txtChatID.Text = Session("ChatID")

        End Sub

        Private Sub btSend_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btSend.Click

                Try
                        Dim strMessageColor As String = txtMessageColor.Text
                        Dim strStatus = ""
                        Dim strText = txtSendMessage.Text

                        If Trim(strMessageColor) = "" Then
                                strMessageColor = "Black"
                        End If


                        If Trim(strText) <> "" Then
                                strText = Server.HtmlEncode(strText)
                                'strText = "<font color=" & strMessageColor & ">" & strText & "</font>"
                                SendMessage(strText)
                        End If
                        txtSendMessage.Text = ""

                Catch ex As Exception
                        txtSendMessage.Text = ex.Message
                End Try
        End Sub


        Private Sub btSignOut_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btSignOut.Click

                Try
                        RemoveChatUser()

                        Dim sScript As String
                        sScript &= "<script language=javascript>"
                        sScript &= "parent.location.href='../ChatWelcome.aspx';"
                        sScript &= "</script>"
                        Response.Write(sScript)


                Catch ex As Exception
                        txtSendMessage.Text = ex.Message
                End Try
        End Sub




        Function SendMessage(ByVal strInpMessage As String)

                'Retrieve the UserID and ChatIDs from the Session Variables (return 0 if they are empty)
                Dim intChatID As Integer = IIf(Trim(Session("ChatID") = ""), 0, CInt(Session("ChatID")))
                Dim intUserID As Integer = IIf(Trim(Session("UserID") = ""), 0, CInt(Session("UserID")))
                Dim strMessage As String = Replace(strInpMessage, "'", "`")

                'Add the message to the current chat message table
                objChatBLL.AddChatMessage(intChatID, intUserID, strMessage)

        End Function

        Private Sub txtChatID_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
                Session("ChatID") = txtChatID.Text
        End Sub


        Private Sub RemoveChatUser()
                Try
                        'If the current user happened to be in any other chats, remove him from there as well
                        objChatBLL.DeleteSession(Session.SessionID)

                        'Retrieve the UserID and ChatIDs from the Session Variables (return 0 if they are empty)
                        Dim intChatID As Integer = IIf(Trim(Session("ChatID") = ""), 0, CInt(Session("ChatID")))
                        Dim intUserID As Integer = IIf(Trim(Session("UserID") = ""), 0, CInt(Session("UserID")))

                        'If the user is in the UserChat table, remove him.
                        objChatBLL.RemoveUserFromChat(intChatID, intUserID)

                Catch ex As Exception
                        txtChatID.Text = ex.Message

                End Try



        End Sub

        Private Sub btRemove_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btRemove.Click
                RemoveChatUser()
        End Sub
End Class
