#region Copyright (c) 2002-2005, Bas Geertsema, Xih Solutions (http://www.xihsolutions.net)
/*
Copyright (c) 2002-2005, Bas Geertsema, Xih Solutions (http://www.xihsolutions.net)
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, 
this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright 
notice, this list of conditions and the following disclaimer in the 
documentation and/or other materials provided with the distribution.
* Neither the names of Bas Geertsema or Xih Solutions nor the names of its 
contributors may be used to endorse or promote products derived 
from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
THE POSSIBILITY OF SUCH DAMAGE. */
#endregion

using System;
using XihSolutions.DotMSN.Core;
using XihSolutions.DotMSN.DataTransfer;

namespace XihSolutions.DotMSN.Core
{
	#region MessageHandler Handlers
	/// <summary>
	/// This delegate is used when the server sends an error code. 
	/// </summary>
	public delegate void ErrorReceivedEventHandler(object sender, MSNErrorEventArgs e);

	/// <summary>
	/// This delegate is used when an exception was thrown inside the message handler class.
	/// </summary>
	public delegate void HandlerExceptionEventHandler(object sender, ExceptionEventArgs e);
	#endregion

	/// <summary>
	/// IMessageHandler defines the methods required to handle incoming network messages.
	/// </summary>
	public interface IMessageHandler
	{
		/// <summary>
		/// Gets or sets the processor of network messages. 
		/// Every message handler is associated with a single message processor.
		/// This way the handler can initiate, or send, messages which are not a reply
		/// on incoming messages.
		/// </summary>
		IMessageProcessor MessageProcessor
		{
			get;
			set;
		}

		/// <summary>
		/// A IMessageProcessor calls this method. The handler can then process the
		/// message.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <param name="message"></param>
		/// <param name="sender"></param>
		void HandleMessage(IMessageProcessor sender, NetworkMessage message);		
	}
}
