<?php

require_once( "class.hangman.php" );

print( "<h3>Hangman</h3>" );
print( "A game programmed by <b>Shady El Gewily</b><br /><hr />" );
session_start();

if( isset( $_POST[ "new" ] ) )
{
	session_destroy();
	print( "<script language='javascript'>window.location='example.php'</script>" );
}

if( isset( $_SESSION[ "hangman" ] ) )
{
	$oGame = $_SESSION[ "hangman" ];
} else {
	$_SESSION[ "hangman" ] = new Hangman();
	$oGame = $_SESSION[ "hangman" ];
}

if( isset( $_POST[ "submit" ] ) )
{
	if( strlen( $_POST[ "word" ] ) == 0 )
	{
		$oGame->checkLetter( $_POST[ "guess" ] );
	} else {
		$oGame->setGuessWord( $_POST[ "word" ] );
	}
}

print( "Current word: " );
$oGame->printWord();
print( "<br /><hr />" );

if( $oGame->iStatus != 0 )
{
	print( "Current status: <img src='" . $oGame->getStatus() . "' />" );
	print( "<br /><hr />" );
}

if( sizeof( $oGame->aTriedLetters ) != 0 )
{
	print( "Tried letters: " );
	for( $i = 0; $i < sizeof( $oGame->aTriedLetters ); $i++ )
	{
		print( $oGame->aTriedLetters[ current( $oGame->aTriedLetters ) ] . ", " );
		next( $oGame->aTriedLetters );
	}
	print( "<br /><hr />" );
}

if( $oGame->checkDead() )
{
	session_destroy();
	print( "<h3>You lost!</h3>" );
	print( "The word was '" . $oGame->sWord . "'<br />" );
	print( "<a href='index.php'>Play again</a>" );
	exit();
}

if( $oGame->wordGuessed() )
{
	session_destroy();
	print( "<h3>You won!</h3>" );
	print( "You guessed the word '" . $oGame->sWord . "' " );
	print( "in <b>" . $oGame->iGuesses . "</b> guesses<br />" );
	print( "<a href='index.php'>Play again</a>" );
	exit();
}

$_SESSION[ "hangman" ] = $oGame;

print( "<form method='POST' action='example.php'>" );
print( "Guess letter: " );
print( "<select name='guess'>" );
for( $i = 97; $i < 123; $i++ )
{
	if( array_key_exists( chr( $i ), $oGame->aTriedLetters ) )
	{
		print( "<option disabled>" . chr( $i ) ."</option>" );
	} else {
		print( "<option>" . chr( $i ) . "</option>" );
	}
}
print( "</select>" );
print( "<br />" );
print( "Guess word: <input type='text' name='word' /><br />" );
print( "<input type='submit' name='submit' value='Guess' />&nbsp;" );
print( "<input type='submit' name='new' value='New game' />" );
print( "</form>" );