<?

// iQuiz v1.0 - a simple quiz script
// You may change any of this script but please do not remove the link at the bottom of the page
$xmlFile = "questions.xml";

// header and footer
$headerFile = "header.htm";
$footerFile = "footer.htm";

// XML Section
$data = implode("", file($xmlFile));
$parser = xml_parser_create();
xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
xml_parse_into_struct($parser, $data, $values, $tags);
xml_parser_free($parser);

$questionNo = 0;
foreach ($values as $key=>$val) {
	// save value to "questions" array if this is a TEXT tag
	if ($val[tag] == "TEXT") {
		$questions[$questionNo]['text'] = $val[value];
	}

	// save value to "questions" array if this is a CHOICES tag
	if ($val[tag] == "CHOICES") {
		$questions[$questionNo]['choices'] = $val[value];
	}

	// save value to "questions" array if this is an ANSWER tag
	if ($val[tag] == "ANSWER") {
		$questions[$questionNo]['answer'] = $val[value];

		// increment question counter variable
		$questionNo++;
	}
}

import_request_variables("p", "post_");

include($headerFile);

if (!isset($post_answers)) {
	echo "<b>" . $questions[0]['text'] . "</b>\n";
	echo "<form action=\"$PHP_SELF\" method=\"post\">\n";

	// split choices into "choices" array
	$choices = explode(", ", $questions[0]['choices']);

	// print text field if there are no choices
	if (count($choices) == 1) {
		echo "<input type=\"text\" name=\"answers[0]\" size=10>\n";
	}

	// print radio fields if there are multiple choices
	else {
		// print a radio button for each choice
		for ($i = 0; $i < count($choices); $i++) {
			echo "<input type=\"radio\" name=\"answers[0]\" value=\"" . $choices[$i] . "\"> " . $choices[$i] . "<br>\n";
		}
	}

	echo "<input type=\"submit\" value=\"Next Question\">\n";
	echo "</form>\n";
}


//
// PRINT NEXT QUESTION
//

elseif (count($questions) > count($post_answers)) {
	// get number of next question
	$nextQuestion = count($post_answers);

	// print question
	echo "<b>" . $questions[$nextQuestion]['text'] . "</b>\n";
	echo "<form action=\"$PHP_SELF\" method=\"post\">\n";

	// print answers to previous questions as hidden form fields
	for ($i = 0; $i < count($post_answers); $i++) {
		echo "<input type=\"hidden\" name=\"answers[$i]\" value=\"$post_answers[$i]\">\n";
	}

	// split choices into "choices" array
	$choices = explode(", ", $questions[$nextQuestion]['choices']);

	// print text field if there are no choices
	if (count($choices) == 1) {
		echo "<input type=\"text\" name=\"answers[$nextQuestion]\" size=10>\n";
	}

	// print radio fields if there are multiple choices
	else {
		// print a radio button for each choice
		for ($i = 0; $i < count($choices); $i++) {
			echo "<input type=\"radio\" name=\"answers[$nextQuestion]\" value=\"" . $choices[$i] . "\">" . $choices[$i] . "<br>\n";
		}
	}

	// print appropriate button label
	if (count($questions) == count($post_answers) + 1) {
		echo "<input type=\"submit\" value=\"Calculate Score\">\n";
	}
	else {
		echo "<input type=\"submit\" value=\"Next Question\">\n";
	}

	echo "</form>\n";
}


//
// CALCULATE AND PRINT SCORE
//

else {
	// get number of questions
	$noQuestions = count($questions);

	// get number of correct answers
	for ($i = 0; $i < $noQuestions; $i++) {
		// increment "noCorrectAnswers" variable if user has correct answer
		if ($questions[$i]['answer'] == $post_answers[$i]) {
			$noCorrectAnswers++;
		}
	}

	// calculate score
	$score = ($noCorrectAnswers / $noQuestions) * 100;

	// round score to nearest whole precentage point
	$score = round($score);

	// print score
	echo "<h2>$score%</h2>\n";

	if ($noCorrectAnswers == 0) {
		echo "<p>You answered no questions correctly.  <a href=" . $PHP_SELF . ">Try again.</a></p>";
	}

	if ($noCorrectAnswers == 1) {
		echo "<p>You answered 1 out of $noQuestions questions correctly.  <a href=" . $PHP_SELF . ">Try again.</a></p>";
	}

	if ($noCorrectAnswers > 1 && $noCorrectAnswers < $noQuestions) {
		echo "<p>You answered $noCorrectAnswers out of $noQuestions questions correctly.  <a href=" . $PHP_SELF . ">Try again.</a></p>";
	}

	if ($noCorrectAnswers == $noQuestions) {
		echo "<p>You answered all questions correctly!</p>";
	}
}


//
// INCLUDE FOOTER FILE
//

include($footerFile);

?>