<?php
##################################################################################
#    FANTACALCIOBAZAR
#    Copyright (C) 2003 - 2005 by Antonello Onida (fantacalcio@sassarionline.net)
#    Copyright (C) 2001 - 2002 by Marco Maria Francesco De Santis (marcods@gmx.net)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##################################################################################

if ($vedi_notizie == 1) {
require ("./dati/globali.inc.php");

	$path_to_images = "images";

	if ( file_exists( "./dati/" . $language . ".inc.php" ) )
	{
		$loc_lang = $language;
	}
	else
	{
		$loc_lang = $default_language;
	}

	require ( "./dati/" . $loc_lang . ".inc.php" );

echo "<table width=\"$dimensioni_tabella_notizie\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" align=\"right\" bgcolor=\"$sfondo_tab\">
  <tr><td class=\"testa\">Flash News</td></tr><tr><td valign=\"top\">";

	if ( $data_source == "mysql" )
	{
		// include class for database support
		require ( "./dati/mysql.inc.php" );

		// prepare objects for database access
		$news_list            = new mysql;
		$news_list->name      = $index_file;
		$news_list->server    = $db_server;
		$news_list->login     = $db_login;
		$news_list->password  = $db_password;
		$news_list->database  = $db_database;
		$news_list->init();

		$promo_list           = new mysql;
		$promo_list->name     = $promo_index;
		$promo_list->server   = $db_server;
		$promo_list->login    = $db_login;
		$promo_list->password = $db_password;
		$promo_list->database = $db_database;
		$promo_list->init();
	}

	if ( $data_source == "csvfile" )
	{
		// include class for CSV-textfile support
		require ( "./dati/csvfile.inc.php" );

		// prepeare objects for file access
		$news_list        = new csvfile;
		$news_list->name  = $index_file;
		$news_list->init();

		$promo_list       = new csvfile;
		$promo_list->name = $promo_index;
		$promo_list->init();
	}

	function show_entry( $data )
	{
		global $path_to_images;

		if ( !empty( $data["news_head_link"] ) )
		{
			$news_field = '<h3><a href="'.$data["news_head_link"].'">'.$data["news_title"]."</a></h3>";
		}
		else
		  $news_field = "<U><B><font size=\"2\">".$data["news_title"]."</font></B></U><br />"
		  . "<i><font size=\"1\">".gmdate("d.m.Y H:i",$data["news_stamp"]). " [";

		if ( !empty( $data["news_editorial_contact"] ) )
		{
			$news_field .= '<a href="'.$data["news_editorial_contact"].'">'.$data["news_editor"]."</a>";
		}
		else
		  $news_field .= $data["news_editor"];

		$news_field .= "]</font></i><br />";


		$news_field .= $data["news_content"]."<br />";
		if ( !empty( $data["news_head_image"] ) )
		{
			$image_field = '<img src="'.$path_to_images.'/'.$data["news_head_image"].'">';
		} else $image_field = "&nbsp;";

$entry = <<<ENTRY
<tr>
  <td valign="top"><div align="justify">$news_field $image_field</div></td>
</tr>
ENTRY;
			return $entry;
	}

	if (!empty ($HTTP_GET_VARS["page"] ) )
  		{ $page = $HTTP_GET_VARS["page"]; }
	else
  		{ $page = 0; }

	$now_stamp = gmmktime( );

	if (!empty( $HTTP_GET_VARS[ "lp" ] ))
	{
		$start_pos_count = $HTTP_GET_VARS[ "lp" ];
	} else $start_pos_count = 1;

	$pos_count = $start_pos_count;

	$pl_pos = 0;
	$num_promo = $promo_list->entries();
	$promo_data = array();
	if ($num_promo > 0)
	{
		$promo_list->get_entry( $pl_pos, $promo_data );
		while ( ($promo_data[ "promo_pos" ] < $start_pos_count) && !$promo_list->eol() )
		{ $promo_list->get_next_entry( $promo_data ); }
	}

	$num_news  = $news_list->entries();
	if ( $start_pos_count > $num_news) { $promo_list->eol = true; }
	$news_data = array();
	$news_list->get_entry( $start_pos_count-1, $news_data );
	$page_break = false;

	$odd_sign = 1;
	do
	{
			while ( $num_promo > 0 && ( $promo_data["promo_pos"] == $pos_count ) && ( !$promo_list->eol() ) )
			{

				$show = false;

				if ( !empty( $promo_data["promo_start"]) && $now_stamp >= $promo_data["promo_start"] )
				{
					$show = true;
				}
				else $show = false;


				if ( empty( $promo_data["promo_start"]) && !empty( $promo_data["promo_stop"]) )
				{
					$show = true;
				}

				if ( !empty( $promo_data["promo_stop"]) && $now_stamp >= $promo_data["promo_stop"] )
				{
					$show = false;
				}

				if ( empty( $promo_data["promo_start"]) && empty( $promo_data["promo_stop"]) )
				{
					$show = true;
				}

				if ($show)
				{
					echo "<table>". show_entry( $promo_data, $odd_sign ) . "</table><br />";
					$odd_sign++;
				}

				$promo_list->get_next_entry( $promo_data );
			}


			if ( !$news_list->eol() )
			{
				if ($news_data["hide_entry"] != "1" )
				{
					echo "<table>". show_entry( $news_data, $odd_sign ) . "</table><br />";
					$odd_sign++;
				}

				$news_list->get_next_entry( $news_data );
			}

		$pos_count++;


		$prev_start_pos = $start_pos_count - $news_per_pagina;
		if ($prev_start_pos < 1) $prev_start_pos = 1;

		$next_start_pos = $pos_count;
		$pages = ceil($num_news / $news_per_pagina);
		$page = ceil($start_pos_count / $news_per_pagina);


		if ( $start_pos_count == 1 && $pos_count > $news_per_pagina )
		{
			$page_break = true;
			$nav_left =  '';
			$nav_right = '<a href="'.$PHP_SELF."?lp=$next_start_pos&list_id=$list_id&amp;language=$language" . '"> '. $_older_entries.'</a>';
		}

		elseif ( $pos_count - $start_pos_count >= $news_per_pagina &&
		     !$news_list->eol() )
		{
			$page_break = true;
			$nav_left =  '<a href="'.$PHP_SELF."?lp=$prev_start_pos&amp;list_id=$list_id&amp;language=$language" . '"> '. $_newer_entries.'</a>';
			$nav_right = '<a href="'.$PHP_SELF."?lp=$next_start_pos&amp;list_id=$list_id&amp;language=$language" . '"> '. $_older_entries.'</a>';
		}

		elseif ( $pos_count > $news_per_pagina && $news_list->eol() )
		{
			$page_break = true;
			$nav_left =  '<a href="'.$PHP_SELF."?lp=$prev_start_pos&amp;list_id=$list_id&amp;language=$language" . '"> '. $_newer_entries.'</a>';
			$nav_right = '';
		}


if ($page_break and $pages > 1)
echo <<<NAVIGATION
<hr><center>
$nav_left | $page $_of $pages | $nav_right
NAVIGATION;

	} while ( (!$promo_list->eol() || !$news_list->eol()) && !$page_break );

echo "</center></td></tr></table>";

}
?>