<?php
##################################################################################
#    FANTACALCIOBAZAR
#    Copyright (C) 2003-2005 by Antonello Onida (fantacalcio@sassarionline.net)
#    Copyright (C) 2001-2002 by Marco Maria Francesco De Santis
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##################################################################################
require ("./controlla_pass.php");
require ("./header.php");

if ($_SESSION["utente"] != "admin") include("menu.php");

	// set to your own?!
	$path_to_images = "immagini";

	// global variables (have to be fitted)
	require ("./dati/globals.inc.php");


	// (If exists) include localization file for the favoured language
	if ( file_exists( "./dati/" . $language . ".inc.php" ) )
	{
		$loc_lang = $language;
	}
	else
	{
		$loc_lang = $default_language;
	}

	require ( "./dati/" . $loc_lang . ".inc.php" );


?>

<head>
	<title><?php echo $newspage_title. ' - ' .$_archive; ?></title>
	<link rel="stylesheet" href="<?php echo $css_file; ?>">
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $charset ?>">
  	<meta http-equiv="cache-control" content="no-cache">
  	<meta http-equiv="pragma" content="no-cache">
  	<meta http-equiv="expires" content="0">
</head>

<body>
<table width="100%" border="0" cellspacing="0" cellpadding="0" height="100%">
  <tr>
    <td><h3><?php echo $newspage_title. ' - ' .$_archive; ?></h3><br>
<?php

	if ( $data_source == "mysql" )
	{
		// include class for database support
		require ( "./dati/mysql.inc.php" );

		// prepare objects for database access
		$news_list            = new mysql;
		$news_list->name      = $index_file;
		$news_list->server    = $db_server;
		$news_list->login     = $db_login;
		$news_list->password  = $db_password;
		$news_list->database  = $db_database;
		$news_list->init();

		$promo_list           = new mysql;
		$promo_list->name     = $promo_index;
		$promo_list->server   = $db_server;
		$promo_list->login    = $db_login;
		$promo_list->password = $db_password;
		$promo_list->database = $db_database;
		$promo_list->init();
	}

	if ( $data_source == "csvfile" )
	{
		// include class for CSV-textfile support
		require ( "./dati/csvfile.inc.php" );

		// prepeare objects for file access
		$news_list        = new csvfile;
		$news_list->name  = $index_file;
		$news_list->init();

		$promo_list       = new csvfile;
		$promo_list->name = $promo_index;
		$promo_list->init();
	}

if ( !empty( $HTTP_GET_VARS[ "do" ] ) )
{ $do = $HTTP_GET_VARS[ "do" ]; }
else
  $do = "overview";

if ($do == "overview")
{
	echo "<p>$_archived_by_years :</p>";

	$data = array();
	$news_list->get_entry( 0, $data );

	$last_year = gmdate( "Y" , $data["news_stamp"] );
	$next_earlier_year = gmmktime( "00","00","00","01","01", ($last_year) );
	echo '<a href="'.$PHP_SELF."?do=show_index&year=$last_year&language=$language&list_id=$list_id".'">'.$last_year.'</a><br>';

	do
	{
		if ($data["news_stamp"] < $next_earlier_year)
		{
			$last_year = gmdate("Y",$data["news_stamp"] );
			$next_earlier_year = gmmktime( "00","00","00","01","01", ($last_year) );
			echo '<a href="'.$PHP_SELF."?do=show_index&year=$last_year&language=$language&list_id=$list_id".'">'.$last_year.'</a><br>';
		}

		$news_list->get_next_entry( $data );
	} while ( !$news_list->eol() );

}


if ($do == "show_index")
{
	if (!empty($HTTP_GET_VARS["year"]))
	{
		$year = $HTTP_GET_VARS["year"];
	} else exit;

	echo "<p>$_news_of_the_year <b>$year</b>:</p>";

	$data = array();
	$news_list->get_entry( 0, $data );

	$start_year = gmmktime( "00","00","00","01","01", $year );
	$end_year   = gmmktime( "23","59","59","12","31", $year );

	echo "<table><tr><td>&nbsp;</td></td>&nbsp;</td>";

	do
	{
		if ( ( $data["news_stamp"] >= $start_year ) &&
		     ( $data["news_stamp"] <= $end_year ) &&
		     ( $data["hide_entry"] != "1" ) )
		{
			echo '<tr><td id="archive_news_date"><nobr>'.gmdate("d.m.Y H:i",$data["news_stamp"])."</nobr></td>"
			.'<td id="archive_news_title"><a href="'.$PHP_SELF."?do=show_news&date=".$data["news_stamp"]."&language=$language&list_id=$list_id".'">'.$data["news_title"].'</a></td></tr>'."\n";
		}
		$news_list->get_next_entry( $data );

	} while ( !$news_list->eol() );
	echo "</table>"
	."<p>&nbsp;</p>"
	."<p>".'<a href="'.$PHP_SELF."?language=$language&list_id=$list_id".'">'.$_back_to_start."</a></p>\n";

}


function show_entry( $data, $i )
	{
		global $path_to_images;

		if ( !empty( $data["news_head_link"] ) )
		{
			$news_field = '<h3><a href="'.$data["news_head_link"].'">'.$data["news_title"]."</a></h3>\n";
		}
		else
		  $news_field = "<h3>".$data["news_title"]."</h3>\n";

		$news_field .= "    <p>".$data["news_content"]."</p>\n"
		. "    <p class=\"editorialinfo\">".gmdate("d.m.Y H:i",$data["news_stamp"]). " [";

		if ( !empty( $data["news_editorial_contact"] ) )
		{
			$news_field .= '<a href="'.$data["news_editorial_contact"].'">'.$data["news_editor"]."</a>";
		}
		else
		  $news_field .= $data["news_editor"];

		$news_field .= "]</p>\n  ";

		if ( !empty( $data["news_head_image"] ) )
		{
			$image_field = '<img src="'.$path_to_images.'/'.$data["news_head_image"].'">';
		} else $image_field = "&nbsp;";

		if ( ( $i % 2 ) == 1 )
		{
$odd_entry = <<<ODDENTRY
<tr>
  <td valign="top">$news_field</td>
  <td><img src="$path_to_images/1x1.gif" height="1" width="10">
  <td valign="top">$image_field</td>
</tr>
ODDENTRY;
			return $odd_entry;
		}
		else
		{
$even_entry = <<<EVENENTRY
<tr>
  <td valign="top">$image_field</td>
  <td><img src="$path_to_images/1x1.gif" height="1" width="10">
  <td valign="top">$news_field</td>
</tr>
EVENENTRY;
			return $even_entry;
		}

	}


if ($do == "show_news")
{
	if ( !empty( $HTTP_GET_VARS["date"] ))
	{
		$date = $HTTP_GET_VARS["date"];
	} else exit;


	$break = false;

	$news_list->get_entry( 0, $data );
	do
	{
		if ( $data["news_stamp"] == $date )
		{
			echo "<table class=\"news\">\n". show_entry( $data, 1 ) . "</table>\n<p>&nbsp;</p>\n\n";
			$break = true;
		}

		$news_list->get_next_entry( $data );
	}
	while ( !$news_list->eol() && !$break );

	$year = gmdate("Y",$date );
	echo "<p>".'<a href="'.$PHP_SELF."?do=show_index&year=$year&language=$language&list_id=$list_id".'">'.$_back_to_index."</a></p>\n";
}

echo"</td></tr></table>";

if ($_SESSION["utente"] != "admin") echo"</td></tr></table>";

require("./footer.php");
?>