<?php
##################################################################################
#    FANTACALCIOBAZAR
#    Copyright (C) 2003-2005 by Antonello Onida (fantacalcio@sassarionline.net)
#    Copyright (C) 2001-2002 by Marco Maria Francesco De Santis
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##################################################################################
require("./controlla_pass.php");
require("./header.php");

if ($_SESSION['valido'] == "SI" and $_SESSION['permessi'] >= 1) {
require("./menu.php");

require ("./dati/globali.inc.php");

	if ( file_exists("./dati/" . $language . ".inc.php" ) )
	{
		$loc_lang = $language;
	}
	else
	{
		$loc_lang = $default_language;
	}

	require ("./dati/" . $loc_lang . ".inc.php" );

	$news_per_pagina = 50;

	echo"<br/><table width=\"100%\" border=\"0\" class=\"border\" cellspacing=\"0\" cellpadding=\"5\" bgcolor=\"$sfondo_tab\">
	<tr><td class=\"testa1\">$_newspage_admin_tool</td></tr><tr><td>";

if ( $data_source == "mysql" )
{
	require ("./dati/mysql.inc.php" );

	// prepare objects for database access
	// list of subscribers which signed in/off
	$news_list            = new mysql;
	$news_list->name      = $index_file;
	$news_list->server    = $db_server;
	$news_list->login     = $db_login;
	$news_list->password  = $db_password;
	$news_list->database  = $db_database;
	$news_list->order_criterion = "news_stamp";
	$news_list->init();

	$promo_list           = new mysql;
	$promo_list->name     = $promo_index;
	$promo_list->server   = $db_server;
	$promo_list->login    = $db_login;
	$promo_list->password = $db_password;
	$promo_list->database = $db_database;
	$promo_list->order_criterion = "promo_pos";
	$promo_list->init();
}

if ( $data_source == "csvfile" )
{
	// include class for CSV-textfile support
	require ("./dati/csvfile.inc.php" );

	// prepeare objects for file access
	// list of subscribers which signed in/off
	$news_list        = new csvfile;
	$news_list->name  = $index_file;
	$news_list->init();

	$promo_list       = new csvfile;
	$promo_list->name = $promo_index;
	$promo_list->init();

}

if ( !empty( $HTTP_GET_VARS[ "do" ] ) )
{
	$do = $HTTP_GET_VARS[ "do" ];
}
else { $do = "list"; }

if ( !empty( $HTTP_GET_VARS[ "id" ] ) )
{
	$id = $HTTP_GET_VARS[ "id" ];
}
else { $id = 0; }

if ( !empty( $HTTP_GET_VARS[ "src" ] ) )
	{ $src = $HTTP_GET_VARS["src"]; }


if ( $do == "list" )
{

	function show_entry( $data, $list_pos, $src, $id )
	{
		global $PHP_SELF, $language, $list_id, $_edit, $_delete;

		if ($src == "promo_list")
			{ $src_id = "promo_list"; }
		else
			{ $src_id = "news_list"; }

		$line_color = $list_pos % 2;

		echo '<tr class="linecolor'.$line_color.'" id="'.$src_id.'">'
		. '<td valign="top">'
		.'<a href="'.$PHP_SELF.'?do=edit_entry&id='
		.$id."&language=$language&list_id=$list_id&src=$src_id"
		.'"><img src="./images/edit_entry.gif" alt="'.$_edit.'" border="0"></a>&nbsp;'
		. '<a href="'.$PHP_SELF.'?do=delete_entry&id='
		.$id."&language=$language&list_id=$list_id&src=$src_id"
		.'"><img src="./images/delete_entry.gif" alt="'.$_delete.'" border="0"></a>&nbsp;'
		.'</td>'
		. '<td valign="top"><img src="./images/1x1.gif" width=20">'."</td>\n"
		. '<td valign="top"><nobr>' . gmdate("d.m.Y H:i",$data["news_stamp"]). "</nobr></td>\n"
		. '<td valign="top"><img src="./images/1x1.gif" width=20">'."</td>\n"
		. '<td valign="top">'. $data["news_title"]. "</td></tr>\n";

	} // show_entry

	if (!empty ($HTTP_GET_VARS["page"] ) )
  		{ $page = $HTTP_GET_VARS["page"]; }
	else
  		{ $page = 0; }

	$now_stamp = gmmktime( );

	echo '<br><a href="'.$PHP_SELF."?do=new_entry&language=$language&list_id=$list_id".'"><img src="./images/new_entry.gif" alt="'.$_new_entry.'" border="0">'."</a> &nbsp; $_new_entry<hr>";
	echo '<table cellpadding="0" cellspacing="0">'."\n";

	if (!empty( $HTTP_GET_VARS[ "lp" ] ))
	{
		$start_pos_count = $HTTP_GET_VARS[ "lp" ];
	} else $start_pos_count = 1;

	$pos_count = $start_pos_count;

	$pl_pos = 0;
	$num_promo = $promo_list->entries();
	$promo_data = array();
	if ($num_promo > 0)
	{
		$promo_list->get_entry( $pl_pos, $promo_data );
		while ( ($promo_data[ "promo_pos" ] < $start_pos_count) && !$promo_list->eol() )
		{ $promo_list->get_next_entry( $promo_data ); }
	}

	$num_news  = $news_list->entries();
	$news_data = array();
	$news_list->get_entry( $start_pos_count-1, $news_data );

	$odd_sign = 1;
	do
	{
			while ( $num_promo > 0 && ( $promo_data["promo_pos"] == $pos_count ) && ( !$promo_list->eol() ) )
			{
					echo show_entry( $promo_data, $odd_sign, "promo_list", $promo_list->list_next_pos-1 );
					$odd_sign++;

				$promo_list->get_next_entry( $promo_data );
			}


			if ( !$news_list->eol() )
			{
				echo show_entry( $news_data, $odd_sign, "news_list", $news_list->list_next_pos-1 );
				$odd_sign++;

				$news_list->get_next_entry( $news_data );
			}

		$pos_count++;

		if ( $pos_count - $start_pos_count >= $news_per_pagina)
		{
			$page_break = true;
			$prev_start_pos = $start_pos_count - $news_per_pagina;
			if ($prev_start_pos < 1) $prev_start_pos = 1;

			$next_start_pos = $pos_count;
			$pages = ceil($num_news / $news_per_pagina);
			$page = ceil($start_pos_count / $news_per_pagina);

			echo '<td colspan="5"><br><table border="0" width="100%"><tr><td align="center">'
			. '&lt; <a href="'.$PHP_SELF."?lp=".$prev_start_pos . '">'.$_newer_entries.'</a> '
			. " | $page $_of $pages | "
			. '<a href="'.$PHP_SELF."?lp=".$next_start_pos . '">'.$_other_entries.'</a> &gt;'
			. "</td></tr></table>\n</td>";

		}
		else {$page_break = false;}

	} while ( (!$promo_list->eol() || !$news_list->eol()) && !$page_break );


	echo "<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>"
	. "<tr><td>&nbsp;</td>".'<td><img src="./images/1x1.gif" width=10">'."</td>\n"
	."</table>\n";

	echo '<hr><br><a href="'.$PHP_SELF."?do=new_entry&language=$language&list_id=$list_id".'"><img src="./images/new_entry.gif" alt="'.$_new_entry.'" border="0">'."</a> &nbsp; $_new_entry";


}

if ( $do == "new_entry" )
{
	$mode = "create";
	$do = "edit_entry";
	$src = "news_list";
	$chk = "";
}


if ( $do == "edit_entry" )
{

	$old_forced_pos = 1;
	$old_news_start = $old_news_stop = 0;

	if (!empty( $mode ) && ( $mode == "create" ) )
	{
		$old_news_date_year         = gmdate( "Y" );
		$old_news_date_month        = gmdate( "m" );
		$old_news_date_day          = gmdate( "d" );
		$old_news_date_hour         = gmdate( "H" );
		$old_news_date_minute       = gmdate( "i" );
		$old_news_title             = "News del " . gmdate( "d.m.Y H:i" );
		if ($_SESSION['utente']=="admin") {
		$old_news_editor            = $nome_admin_in_messaggi;
		$old_news_editorial_contact = $email_mittente;
		}
		else
		{
		$old_news_editor            = $_SESSION['utente'];
		$old_news_editorial_contact = "";
		}
		$old_news_head_link         = "";
		$old_news_head_image        = "";
		$old_news_content           = "Contenuto di ".$old_news_title;
		$old_news_start             = "";
		$old_news_stop              = "";

	}
	else
	{
		$mode = "update";

		$entry = array();
		if ( $src == "promo_list" )
		{
			$promo_list->get_entry( $id, $entry );
			$old_forced_pos = $entry["promo_pos"];
			$old_news_start = $entry["promo_start"];
			$old_news_stop = $entry["promo_stop"];
			$chk = " checked";
		}

		if ( $src == "news_list" )
		{
			$news_list->get_entry( $id, $entry );
			$chk = "";
		}

		$old_news_date_year         = gmdate( "Y", $entry["news_stamp"] );
		$old_news_date_month        = gmdate( "m", $entry["news_stamp"] );
		$old_news_date_day          = gmdate( "d", $entry["news_stamp"] );
		$old_news_date_hour         = gmdate( "H", $entry["news_stamp"] );
		$old_news_date_minute       = gmdate( "i", $entry["news_stamp"] );
		$old_news_title             = $entry["news_title"];
		$old_news_editor            = $entry["news_editor"];
		$old_news_editorial_contact = $entry["news_editorial_contact"];
		$old_news_head_link         = $entry["news_head_link"];
		$old_news_head_image        = $entry["news_head_image"];
		$old_news_content           = ereg_replace("<br>", "\n", $entry["news_content"]);
		$old_hide_entry             = $entry["hide_entry"];
		if ($old_hide_entry == "1") $ohechk = "checked"; else $ohechk = "";

	}

	if ( !empty( $old_news_start ) )
	{
		$old_from_day = gmdate( "d", $old_news_start );
		$old_from_month = gmdate( "m", $old_news_start );
		$old_from_year = gmdate( "Y", $old_news_start );
		$old_from_hour = gmdate( "H", $old_news_start );
		$old_from_minute = gmdate( "i", $old_news_start );
	}
	else
	{
		$old_from_day = "";
		$old_from_month = "";
		$old_from_year = "";
		$old_from_hour = "";
		$old_from_minute = "";
	}

	if ( !empty( $old_news_stop ) )
	{
		$old_to_day = gmdate( "d", $old_news_stop );
		$old_to_month = gmdate( "m", $old_news_stop );
		$old_to_year = gmdate( "Y", $old_news_stop );
		$old_to_hour = gmdate( "H", $old_news_stop );
		$old_to_minute = gmdate( "i", $old_news_stop );
	}
	else
	{
		$old_to_day = "";
		$old_to_month = "";
		$old_to_year = "";
		$old_to_hour = "";
		$old_to_minute = "";
	}

echo <<< FORMSHEET
<form name="form_news" method="post" action="$PHP_SELF?do=$mode&id=$id&language=$language&list_id=$list_id&src=$src">
        <table width="100%" border="0">
          <tr>
            <td>&nbsp;&nbsp;&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="2"><b>$_news_date:</b> (gg-mm-aaaa)</td>
            <td></td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="2">
              <input type="text" name="news_date_day" maxlength="2" size="2" value="$old_news_date_day"> - <input type="text" name="news_date_month" maxlength="2" size="2" value="$old_news_date_month"> - <input type="text" name="news_date_year" maxlength="4" size="4" value="$old_news_date_year">
              </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;&nbsp;&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
          </tr>
		<tr>
            <td>&nbsp;</td>
            <td colspan="2"><b>$_news_time:</b> (oo:mm)</td>
            <td></td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="2">
              <input type="text" name="news_date_hour" maxlength="2" size="2" value="$old_news_date_hour"> : <input type="text" name="news_date_minute" maxlength="2" size="2" value="$old_news_date_minute">
              </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>$_editor: </td>
            <td>
              <input type="text" name="news_editor" maxlength="100" size="50" value="$old_news_editor">
              </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>$_editor_link: </td>
            <td>
              <input type="text" name="news_editorial_contact" maxlength="100" size="50" value="">
              </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>$_news_title: </td>
            <td>
              <input type="text" name="news_title" maxlength="200" size="50" value="$old_news_title">
              </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>$_news_title_link: </td>
            <td>
              <input type="text" name="news_head_link" maxlength="200" size="50" value="$old_news_head_link">
              </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>$_title_image: </td>
            <td>
              <input type="text" name="news_head_image" maxlength="200" size="50" value="$old_news_head_image">
              </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="2">$_news_content (HTML):</td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="2">
              <textarea name="news_content" cols="100" rows="10">$old_news_content</textarea>
            </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>$_hide_entry: <b>
              <input type="checkbox" name="hide_entry" value="1" $ohechk>
              </b></td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>
              <input type="submit" name="Invia" value="$_new/$_change">
            </td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="2"><b>$_extended_entry:
              <input type="checkbox" name="promoted_entry" value="1" $chk>
              </b></td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="2">
              <br>$_show_entry...
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td>&nbsp;</td>
                  <td>gg-mm-aaaa</td>
                  <td>oo:mm</td>
                </tr>
                <tr>
                  <td>$_from</td>
                  <td>
                    <input type="text" name="new_from_day" maxlength="2" size="2" value="$old_from_day">
                    -
                    <input type="text" name="new_from_month" maxlength="2" size="2" value="$old_from_month">
                    -
                    <input type="text" name="new_from_year" maxlength="4" size="4" value="$old_from_year">
                    </td>
                  <td>
                    <input type="text" name="new_from_hour" maxlength="2" size="2" value="$old_from_hour">
                    :
                    <input type="text" name="new_from_minute" maxlength="2" size="2" value="$old_from_minute">
                    </td>
                </tr>
                <tr>
                  <td>$_to</td>
                  <td>
                    <input type="text" name="new_to_day" maxlength="2" size="2" value="$old_to_day">
                    -
                    <input type="text" name="new_to_month" maxlength="2" size="2" value="$old_to_month">
                    -
                    <input type="text" name="new_to_year" maxlength="4" size="4" value="$old_to_year">
                    </td>
                  <td>
                    <input type="text" name="new_to_hour" maxlength="2" size="2" value="$old_to_hour">
                    :
                    <input type="text" name="new_to_minute" maxlength="2" size="2" value="$old_to_minute">
                    </td>
                </tr>
                <tr>
                  <td>$_at_position</td>
                  <td>
                    <input type="text" name="new_forced_pos" maxlength="8" size="8" value="$old_forced_pos">
                    </td>
                  <td> </td>
                </tr>
                <tr>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                </tr>
              </table>
            </td>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</form>

FORMSHEET;

}

if ( $do == "update" )
{
	if ($src == "promo_list" )
	{
		$promo_list->delete( $id );
	}

	if ($src == "news_list" )
	{
		$news_list->delete( $id );
	}

	$do = "create";

}

if ( $do == "delete_entry" )
{
	if ($src == "promo_list" )
	{
		$promo_list->delete( $id );
	}

	if ($src == "news_list" )
	{
		$news_list->delete( $id );
	}

	echo '<meta http-equiv="refresh" content="0;URL='.$PHP_SELF."?do=list&list_id=$list_id&language=$language".'">';
}


if ( $do == "create" )
{

	$new_entry = array();

	if ( !empty( $HTTP_POST_VARS[ "promoted_entry" ] ) )
	  $promoted_entry = $HTTP_POST_VARS[ "promoted_entry" ];
	else
	  $promoted_entry = false;

	$news_stamp = gmmktime(
	$HTTP_POST_VARS["news_date_hour"],
	$HTTP_POST_VARS["news_date_minute"], 0,
	$HTTP_POST_VARS["news_date_month"],
	$HTTP_POST_VARS["news_date_day"],
	$HTTP_POST_VARS["news_date_year"] );

	$new_entry["promo_pos"]              = "";
	$new_entry["promo_start"]            = "";
	$new_entry["promo_stop"]             = "";
	$new_entry["news_stamp"]             = $news_stamp;
	$new_entry["news_title"]             = $HTTP_POST_VARS["news_title"];
	$new_entry["news_editor"]            = $HTTP_POST_VARS["news_editor"];
	$new_entry["news_editorial_contact"] = $HTTP_POST_VARS["news_editorial_contact"];
	$new_entry["news_head_link"]         = $HTTP_POST_VARS["news_head_link"];
	$new_entry["news_head_image"]        = $HTTP_POST_VARS["news_head_image"];
	$new_entry["news_content"]           =
	ereg_replace("(\r\n|\n|\r)", "<br>", $HTTP_POST_VARS["news_content"] );
	$new_entry["hide_entry"]             = $HTTP_POST_VARS["hide_entry"];

     if ( $promoted_entry )
     {
		$start_pos = $HTTP_POST_VARS["new_forced_pos"];
		if ($start_pos < 1) { $start_pos = 1; }
     	$new_entry["promo_pos"] = $start_pos;

     	$promo_start = gmmktime( $HTTP_POST_VARS["new_from_hour"],
		$HTTP_POST_VARS["new_from_minute"], 0,
		$HTTP_POST_VARS["new_from_month"],
		$HTTP_POST_VARS["new_from_day"],
		$HTTP_POST_VARS["new_from_year"] );

		if ($promo_start > 0) { $new_entry["promo_start"] = $promo_start; }

		$promo_stop = gmmktime( $HTTP_POST_VARS["new_to_hour"],
		$HTTP_POST_VARS["new_to_minute"], 0,
		$HTTP_POST_VARS["new_to_month"],
		$HTTP_POST_VARS["new_to_day"],
		$HTTP_POST_VARS["new_to_year"] );


     	if ($promo_stop > 0) { $new_entry["promo_stop"] = $promo_stop; }

		$red_data = array();
		$num_dates = $promo_list->entries();
		$promo_list->get_entry(0,$red_data);

		$i = 0;
		while ( $i<$num_dates && $start_pos >= $red_data["promo_pos"] )
		{
			$promo_list->get_next_entry( $red_data );
			$i++;
		}
		$promo_list->insert( $i, $new_entry );

     }
     else
     {
		unset( $new_entry["promo_pos"] );
		unset( $new_entry["promo_start"] );
		unset( $new_entry["promo_stop"] );

		$red_data = array();
		$num_dates = $news_list->entries();
		$news_list->get_entry(0,$red_data);
		$start_pos = $HTTP_POST_VARS["new_forced_pos"];

		$i = 0;
		while ( $i<$num_dates && $news_stamp < $red_data["news_stamp"] )
		{
			$news_list->get_next_entry( $red_data );
			$i++;
		}
		$news_list->insert( $i, $new_entry );

     }
	echo '<meta http-equiv="refresh" content="0;URL='.$PHP_SELF."?do=list&list_id=$list_id&language=$language".'">';

}

echo "</td></tr></table></td></tr></table>";
} # fine if ($_SESSION["utente"]
else echo"<meta http-equiv=\"refresh\" content=\"0; url=logout.php\">";
require("./footer.php");
?>