<html>
<head>
<title>Estrazione lotto e superenalotto</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
p 
{
font: 12px Verdana, Arial, sans-serif;
color: #FF0000;
}

table, tr, td
{
	border-color: black;
	border-style: solid;
	border-width: 1px;
}

.centra 
{
  text-align: center;
}

.evidenzia
{
background-color: #CCCCCC;
text-align: center
}
</style>
</head>
<body>
<?php
//Realizzato da Nicola Cossu
//Lo script  liberamente modificabile
// In caso vogliate mandare suggerimenti o segnalare bugs: nicola75ss@tiscali.it


/* PORZIONE DI CODICE RELATIVA ALL'ESTRAZIONE DEL LOTTO  */
function estrai_ruota()
{
mt_srand(); // Inizializzo un generatore di numeri casuali migliore

$estratti_diversi = 0; // Inizializzo la variabile altrimenti il parser genererebbe un NOTICE

while ($estratti_diversi < 5) 
	{
		$estratto1 = mt_rand(1,90);
		$estratto2 = mt_rand(1,90);
		$estratto3 = mt_rand(1,90);
		$estratto4 = mt_rand(1,90);
		$estratto5 = mt_rand(1,90);
	
		$ruota = array($estratto1,$estratto2,$estratto3,$estratto4,$estratto5);
		//var_dump($ruota);
		$estratti_diversi = count(array_unique($ruota)); 
		// array_unique mi restituisce l'array eliminando i valori doppi
		// Con la funzione count, conto quanti sono i valori unici rimasti dopo l'eliminazione dei doppioni
		// Se sono 5 esco dal ciclo e ho la mia ruota valida
		// In caso contrario genero una nuova estrazione
	}
return $ruota;
}
// Genero l'estrazione di tutte le ruote del lotto
$ruotaBari = estrai_ruota();
$ruotaCagliari = estrai_ruota();
$ruotaFirenze = estrai_ruota();
$ruotaGenova = estrai_ruota();
$ruotaMilano = estrai_ruota();
$ruotaNapoli = estrai_ruota();
$ruotaPalermo = estrai_ruota();
$ruotaRoma = estrai_ruota();
$ruotaTorino = estrai_ruota();
$ruotaVenezia = estrai_ruota();
$ruotaNazionale = estrai_ruota();

/************************************************************************/
/* PORZIONE DI CODICE RELATIVA ALLA COLONNA VINCENTE DEL SUPER ENALOTTO */
$superenalotto = array($ruotaBari[0]); // Il primo numero  per forza 1 estratto Bari

//Confronto eseguito su ogni singola ruota:
// Verifico se il valore corrente di ogni singola ruota
//  gi presente nell'array che via via si crea.
// Se  gi presente continuo a scorrere il singolo array (la ruota) finch non trova un valore diverso
// A questo punto con array_push lo aggiungo all'array complessivo

$i = 0;
while (in_array($ruotaFirenze[$i],$superenalotto) )
	   $i++;
array_push($superenalotto,$ruotaFirenze[$i]); // Contiene ora Bari e Firenze 
//var_dump($superenalotto);

$i = 0;
while (in_array($ruotaMilano[$i],$superenalotto) )
	   $i++;
array_push($superenalotto,$ruotaMilano[$i]); // Contiene ora Bari, Firenze e Milano
//var_dump($superenalotto);

$i = 0;
while (in_array($ruotaNapoli[$i],$superenalotto) )
	   $i++;
array_push($superenalotto,$ruotaNapoli[$i]); // Contiene ora Bari, Firenze, Milano e Napoli
//var_dump($superenalotto);

$i = 0;
while (in_array($ruotaPalermo[$i],$superenalotto) )
	   $i++;
array_push($superenalotto,$ruotaPalermo[$i]); // Contiene ora Bari, Firenze, Milano, Napoli e Palermo
//var_dump($superenalotto);

$i = 0;
while (in_array($ruotaRoma[$i],$superenalotto) )
	   $i++;
array_push($superenalotto,$ruotaRoma[$i]); // Contiene ora Bari, Firenze, Milano, Napoli, Palermo e Roma
//var_dump($superenalotto);

$i = 0;
while (in_array($ruotaVenezia[$i],$superenalotto) )
	   $i++;
array_push($superenalotto,$ruotaVenezia[$i]); // Contiene ora Bari, Firenze, Milano, Napoli, Palermo, Roma e Venezia
//var_dump($superenalotto);

/*******************************************************************************************************/

$data = date("d/m/Y");
echo "<p>Estrazione del lotto ($data):</p>";
// Visualizza tabella estrazioni
echo "<table>";
echo "<tr>";
echo "<td>Bari</td>";

foreach ($ruotaBari as $key => $estratto)
{
  echo "<td class=\"centra\">";
  // Poich  scontato che il valore da evidenziare sia nella posizione 0 faccio il confronto sulla chiave
  if ($key == 0) 
     echo "<b>$estratto</b>";
  else	 
  	 echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Cagliari</td>";

foreach ($ruotaCagliari as $estratto)
{
  echo "<td class=\"centra\">";
  echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Firenze</td>";

foreach ($ruotaFirenze as $estratto)
{
  echo "<td class=\"centra\">";
  if ($superenalotto[1] == $estratto)
     echo "<b>$estratto</b>";
  else	 
  	 echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Genova</td>";

foreach ($ruotaGenova as $estratto)
{
  echo "<td class=\"centra\">";
  echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Milano</td>";

foreach ($ruotaMilano as $estratto)
{
  echo "<td class=\"centra\">";
   if ($superenalotto[2] == $estratto)
     echo "<b>$estratto</b>";
  else	 
  	 echo $estratto;

  echo "</td>";
}
echo "<tr>";
echo "<td>Napoli</td>";

foreach ($ruotaNapoli as $estratto)
{
  echo "<td class=\"centra\">";
   if ($superenalotto[3] == $estratto)
     echo "<b>$estratto</b>";
  else	 
  	 echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Palermo</td>";

foreach ($ruotaPalermo as $estratto)
{
  echo "<td class=\"centra\">";
   if ($superenalotto[4] == $estratto)
     echo "<b>$estratto</b>";
  else	 
  	 echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Roma</td>";

foreach ($ruotaRoma as $estratto)
{
  echo "<td class=\"centra\">";
   if ($superenalotto[5] == $estratto)
     echo "<b>$estratto</b>";
  else	 
  	 echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Torino</td>";

foreach ($ruotaTorino as $estratto)
{
  echo "<td class=\"centra\">";
  echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Venezia</td>";

foreach ($ruotaVenezia as $estratto)
{
  echo "<td class=\"centra\">";
   if ($superenalotto[6] == $estratto)
     echo "<b>$estratto</b>";
  else	 
  	 echo $estratto;
  echo "</td>";
}
echo "<tr>";
echo "<td>Nazionale</td>";

foreach ($ruotaNazionale as $estratto)
{
  echo "<td class=\"centra\">";
  echo $estratto;
  echo "</td>";
}
echo "</tr>";
echo "</table>";

// Possibilit remotissima ma da contemplare
// Si verifica qualora tutti e 5 i numeri estratti sulla ruota di Roma
// coincidano con i primi 5 numeri gi estratti per la colonna vincente
if (empty($superenalotto[5]))
{
echo "<b>Impossibile realizzare 6 in questa estrazione!</b>";
echo "<br>";
}
echo "<br>";
echo "<p>Super enalotto:</p>";

// Salvo a parte il numero jolly perch, al fine di poter ordinare la colonna vincente
// in ordine crescente, lo devo eliminare dall'array
$numeroJolly = $superenalotto[6];

array_splice($superenalotto,6); // Elimino dall'array l'estratto di Venezia (numero jolly)
asort($superenalotto); // Ordino la colonna vincente in ordine crescente
//var_dump($superenalotto);

echo "<table>";
echo "<tr>"; 
echo "<td colspan=\"6\" class=\"centra\">Colonna vincente</td>";
echo "<td class=\"centra\">Jolly</td>";
echo "</tr>";
echo "<tr>";
  foreach ($superenalotto as $estratto)
  {
    echo "<td>$estratto</td>";
  }
    echo "<td class=\"evidenzia\">$numeroJolly</td>";
echo "</tr>";
echo "</table>";
?>
</body>
</html>
