(function($) {
    // register namespace
    $.extend(true, window, {
        "Slick": {
            "CellSelectionModel":   CellSelectionModel
        }
    });


    function CellSelectionModel(options) {
        var _grid;
        var _canvas;
        var _ranges = [];
        var _self = this;
        var _selector = new Slick.CellPriceSelector({
            "selectionCss": {
                "border": "2px solid black"
            }
        });
        var _options;
        var _defaults = {
            selectActiveCell: true
        };


        function init(grid) {
            _options = $.extend(true, {}, _defaults, options);
            _grid = grid;
            _canvas = _grid.getCanvasNode();
            _grid.onActiveCellChanged.subscribe(handleActiveCellChange);
            grid.registerPlugin(_selector);
            _selector.onCellPriceSelected.subscribe(handleCellPriceSelected);
            _selector.onBeforeCellPriceSelected.subscribe(handleBeforeCellPriceSelected);
        }

        function destroy() {
            _grid.onActiveCellChanged.unsubscribe(handleActiveCellChange);
            _selector.onCellPriceSelected.unsubscribe(handleCellPriceSelected);
            _selector.onBeforeCellPriceSelected.unsubscribe(handleBeforeCellPriceSelected);
            _grid.unregisterPlugin(_selector);
        }

        function removeInvalidPrices(ranges) {
            var result = [];

            for (var i = 0; i < ranges.length; i++) {
                var r = ranges[i];
                if (_grid.canCellBeSelected(r.fromRow,r.fromCell) && _grid.canCellBeSelected(r.toRow,r.toCell)) {
                    result.push(r);
                }
            }

            return result;
        }

        function setSelectedPrices(ranges) {
            _ranges = removeInvalidPrices(ranges);
            _self.onSelectedPricesChanged.notify(_ranges);
        }

        function getSelectedPrices() {
            return _ranges;
        }

        function handleBeforeCellPriceSelected(e, args) {
            if (_grid.getEditorLock().isActive()) {
                e.stopPropagation();
                return false;
            }
        }

        function handleCellPriceSelected(e, args) {
            setSelectedPrices([args.range]);
        }

        function handleActiveCellChange(e, args) {
            if (_options.selectActiveCell) {
                setSelectedPrices([new Slick.Price(args.row,args.cell)]);
            }
        }

        $.extend(this, {
            "getSelectedPrices":            getSelectedPrices,
            "setSelectedPrices":            setSelectedPrices,

            "init":                         init,
            "destroy":                      destroy,

            "onSelectedPricesChanged":      new Slick.Event()
        });
    }
})(jQuery);