﻿<%@ Page Trace="false" Language="C#" AutoEventWireup="false" CodeFile="SlickGrid.aspx.cs" Inherits="SlickGrid" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>SlickGrid - Virtual Grid</title>

    <%-- bill sregio: slickgrid css --%>
    <link rel="stylesheet" href="SlickGrid/css/slick.grid.css" type="text/css" media="screen" charset="utf-8" />
    <link rel="stylesheet" href="SlickGrid/css/ui-darkness/jquery-ui-1.8.4.custom.css" type="text/css" media="screen" charset="utf-8" />
    <link rel="stylesheet" href="SlickGrid/css/examples.css" type="text/css" media="screen" charset="utf-8" />
    <link rel="stylesheet" href="css/ui.jqgrid.css" type="text/css" media="screen" charset="utf-8" />
    <link rel="stylesheet" href="css/ui-darkness/jquery-ui-1.8.4.custom.css" type="text/css" media="screen" charset="utf-8" /> 
    <%-- bill sregio: slickgrid css --%>

    <%-- bill sregio: slickgrid js files --%>
	<script src="SlickGrid/lib/firebugx.js"></script>
	<script src="SlickGrid/lib/jquery-1.4.3.min.js"></script>
	<script src="SlickGrid/lib/jquery-ui-1.8.5.custom.min.js"></script>
	<script src="SlickGrid/lib/jquery.event.drag-2.0.min.js"></script>
	<script src="SlickGrid/lib/jquery.sparkline.min.js"></script>
	<script src="SlickGrid/lib/slick.core.js"></script>
	<script src="SlickGrid/lib/slick.editors.js"></script>
	<script src="SlickGrid/lib/slick.grid.js"></script>
    <script src="SlickGrid/lib/demo.js" type="text/javascript"></script>
    <%-- bill sregio: slickgrid js files --%>


    <style> 
    .cell-title { 
            font-weight: bold; 
    } 
    #contextMenu 
    { 
        background: #e1efc7; 
        border: 1px solid gray;  
        padding: 2px; 
        display: inline-block; 
        min-width: 100px; 
        -moz-box-shadow: 2px 2px 2px silver; 
        -webkit-box-shadow: 2px 2px 2px silver;                  
    }         
    #contextMenu li 
    { 
        padding: 4px;    
        list-style: none; 
        cursor: pointer; 
        background: url("../images/arrow_right_peppermint.png") no-repeat center left; 
        padding-left: 14px; 
    }     
    #contextMenu li:hover 
    { 
        background-color: white; 
    } 
    </style> 

    <style type="text/css" media="screen">
    th.ui-th-column div{
        white-space:normal !important;
        height:auto !important;
        padding:2px;
        text-align: center !important;
        background: url('SlickGrid/images/header-columns-bg.gif') repeat-x center top;
    }
    </style>
    <style type="text/css">
        .row_red
        {
            color: Red !important;
            text-align: center !important;
        }
        .row_lime
        {
            color: Lime !important;
            text-align: center !important;
        }
    </style>    
    <style type="text/css">
        body, html
        {
            font-family: arial;
            font-size: 11pt;
        }
        
        .divlime {
            a.linkText { color:lime; }
            a.linkText:link { color:lime; }   
            a.linkText:visited { color:lime; }
            a.linkText:hover { color:lime; }
        }
        .divred {
            a.linkText { color:red; }
            a.linkText:link { color:red; }   
            a.linkText:visited { color:red; }
            a.linkText:hover { color:red; }
        }
    </style>

    <script type="text/javascript">
        function Log(Text, MessageType) {
            if ((document.getElementById("LogContainer") == undefined)) { return; }
            if (MessageType == "OK") Text = "<span style='color: white;'>" + Text + "</span>";
            if (MessageType == "ERROR") Text = "<span style='color: red;'>" + Text + "</span>";
            document.getElementById("LogContainer").innerHTML = Text + "<br />";
            var LogContainer = document.getElementById("LogContainer");
            LogContainer.scrollTop = LogContainer.scrollHeight;
        };

        function setIPAddress(responseText) {
            document.getElementById("iplabel").innerText = "IP Address: " + responseText;
        }

        function fnStartClock() {
            oInterval = setInterval("CallWebServiceFromJquery()", 1000);
        }

        function fnStopClock() {
            clearInterval(oInterval);
        }

        function CallWebServiceFromJquery() {
            $.ajax({
                type: "POST",
                url: "WebService.asmx/Tick",
                data: "{  }",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: OnSuccess,
                error: OnError
            });

        }

        function OnSuccess(data, status) {
            //alert(data.d);
            messages = data.d;
            for (var i = 0; i < messages.length; i++) {
                var ret = jQuery.parseJSON(messages[i]);
                addRowToTheTop(ret);
                // Bill SerGio - Set maximum rows to display at 10
                SetRowsDisplay(10);
            }
        }

        function OnError(request, status, error) {
            alert(request.statusText);
        }

        $(document).ready(function () {
            fnStartClock();
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="blank" 
        style="font-family: Arial, Helvetica, sans-serif; font-size: x-large; font-weight: bold; color: #FFFFFF">SlickGrid - Virtual JQuery Grid 
        with JSON</div>
    <div id="LogContainer"></div>
    <br />
		<div style="width:1100px; float:left;">
			<div class="grid-header" style="width:100%">
				<label id="iplabel">IP Address: 127.0.0.1</label>
			</div>
			<div id="myGrid" style="width:100%;height:500px;"></div>
		</div>
    <br />
    </form>
</body>
</html>


