﻿using System;
using System.Data;
using System.Web.UI;
using System.Collections;
using System.Text;
using System.Linq;


public partial class NetGridView : System.Web.UI.Page
{
    private object _syncLock = new object();
    public static string IPAddress = "IP Address: 127.0.0.1";

    protected override void OnInit(EventArgs e)
    {
        this.Load += new System.EventHandler(this.Page_Load);
        base.OnInit(e);
    }


    protected void Page_Load(object sender, EventArgs e)
    {
        //if (IsCallback)
        //    return;

        if (!Page.IsPostBack)
        {
            IPAddress = IPHelper.GetIPAddress(Request.ServerVariables["HTTP_VIA"],
                Request.ServerVariables["HTTP_X_FORWARDED_FOR"],
                Request.ServerVariables["REMOTE_ADDR"]);

            runjQueryCode("setIPAddress('" + IPAddress + "');");

            DataTable dt = new DataTable();
            dt.Rows.Add(dt.NewRow()); // add empty row
            gvData.DataSource = dt;
            gvData.DataBind(); 
            gvData.DataSource = Enumerable.Range(1, 1).Select(a => new
            {
                Text0 = "Icon",
                Text1 = "Direction",
                Text2 = "Time",
                Text3 = "Symbol",
                Text4 = "High",
                Text5 = "Low",
                Text6 = "Price",
                Text7 = "Volume",
                Text8 = "News"
            });
            gvData.DataBind(); 
        }
    }

    private string getjQueryCode(string jsCodetoRun)
    {
        StringBuilder sb = new StringBuilder();
        sb.AppendLine("$(document).ready(function() {");
        sb.AppendLine(jsCodetoRun);
        sb.AppendLine(" });");

        return sb.ToString();
    }

    private void runjQueryCode(string jsCodetoRun)
    {
        ScriptManager requestSM = ScriptManager.GetCurrent(this);
        if (requestSM != null && requestSM.IsInAsyncPostBack)
        {
            ScriptManager.RegisterClientScriptBlock(this,
            typeof(Page), Guid.NewGuid().ToString(), getjQueryCode(jsCodetoRun), true);
        }
        else
        {
            ClientScript.RegisterClientScriptBlock(typeof(Page),
            Guid.NewGuid().ToString(), getjQueryCode(jsCodetoRun), true);
        }
    }

    public static void RemoveDuplicates(ref string[] A)
    {
        Array.Sort(A);
        ArrayList list = new ArrayList(A);
        for (int i = list.Count - 1; i > 0; i--)
        {
            if ((string)list[i] == (string)list[i - 1])
                list.RemoveAt(i);
        }
        A = (string[])list.ToArray(typeof(string));
    }



}
