﻿<%@ Page Trace="false" Language="C#" AutoEventWireup="false" CodeFile="NetGridView.aspx.cs" Inherits="NetGridView" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>.NET GridView</title>

    <link href="css/table.css" rel="stylesheet" type="text/css" />
    <link href="css/ui.jqgrid.css" rel="stylesheet" type="text/css" media="screen" />
    <link href="css/ui-darkness/jquery-ui-1.8.4.custom.css" rel="stylesheet" type="text/css" />      
    
    <script src="Scripts/jquery-1.4.1.js" type="text/javascript"></script>

    <style type="text/css" media="screen">
    th.ui-th-column div{
        white-space:normal !important;
        height:auto !important;
        padding:2px;
    }
    </style>
    <style type="text/css">
        .row_red
        {
            color: Red !important;
        }
        .row_lime
        {
            color: Lime !important;
        }
    </style>    
    <style type="text/css">
        body, html
        {
            font-family: arial;
            font-size: 11pt;
        }
        #form1
        {
            width: 889px;
            height: 221px;
        }
        </style>
    <script type="text/javascript">
        var curID = 0;
        var maxRowHigh = 10;

        function Log(Text, MessageType) {
            if ((document.getElementById("LogContainer") == undefined)) { return; }
            if (MessageType == "OK") Text = "<span style='color: white;'>" + Text + "</span>";
            if (MessageType == "ERROR") Text = "<span style='color: red;'>" + Text + "</span>";
            document.getElementById("LogContainer").innerHTML = Text + "<br />";
            var LogContainer = document.getElementById("LogContainer");
            LogContainer.scrollTop = LogContainer.scrollHeight;
        };

        function setIPAddress(responseText) {
            document.getElementById("iplabel").innerText = "IP Address: " + responseText;
        }

        function fnStartClock() {
            oInterval = setInterval("CallWebServiceFromJquery()", 2000); 
        }
        function fnStopClock() {
            clearInterval(oInterval);
        }

        function CallWebServiceFromJquery() {
            $.ajax({
                type: "POST",
                url: "WebService.asmx/Tick",
                data: "{  }",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: OnSuccess,
                error: OnError
            });

        }

        function OnSuccess(data, status) {
            //alert(data.d);
            messages = data.d;
            for (var i = 0; i < messages.length; i++) {
                var ret = jQuery.parseJSON(messages[i]);
                if(ret.Dir == "▼")
                    $('#gvData tbody tr:first').after('<tr style="color:red;"><td><img src="icons_grid/' + ret.ImageID + '.gif" /></td><td><nobr>' + ret.Dir + '</td><td><nobr>' + ret.Time + '</nobr></td><td>' + ret.Symbol + '</td><td>' + ret.High + '</td><td>' + ret.Low + '</td><td>' + ret.Price + '</td><td>' + ret.Volume + '</td><td>' + ret.News + '</td></tr>');
                else
                    $('#gvData tbody tr:first').after('<tr style="color:lime;"><td><img src="icons_grid/' + ret.ImageID + '.gif" /></td><td><nobr>' + ret.Dir + '</td><td><nobr>' + ret.Time + '</nobr></td><td>' + ret.Symbol + '</td><td>' + ret.High + '</td><td>' + ret.Low + '</td><td>' + ret.Price + '</td><td>' + ret.Volume + '</td><td>' + ret.News + '</td></tr>');
                var totalRows = $("#<%=gvData.ClientID %> tr").length;
                if (totalRows > maxRowHigh)
                    $('#gvData tbody tr:last').remove();
            }
        }

        function OnError(request, status, error) {
            alert(request.statusText);
        }

        $(document).ready(function () {
            fnStartClock();
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="blank" 
        style="font-family: Arial, Helvetica, sans-serif; font-size: x-large; font-weight: bold; color: #FFFFFF">.NET GridView 
        with JSON</div>
    <div id="LogContainer"></div>
      <br />     
      <div class="grid-header" style="width:100%">
	    <label id="iplabel">IP Address: 127.0.0.1</label>
      </div>
      <div id="tdGridView">
        <asp:GridView CssClass="tablestyle" ID="gvData" runat="server" CellPadding="0" 
            ForeColor="White" GridLines="Vertical" 
            Width="820px" 
            EmptyDataText="No Data at this time" AutoGenerateColumns="False">                        
            <AlternatingRowStyle CssClass="altrowstyle" />
                <Columns>
                    <asp:TemplateField HeaderText="Icon">
                        <ControlStyle Width="20px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Dir">
                        <ControlStyle Width="30px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Time">
                        <ControlStyle Width="100px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Symbol"></asp:TemplateField>
                    <asp:TemplateField HeaderText="High"></asp:TemplateField>
                    <asp:TemplateField HeaderText="Low"></asp:TemplateField>
                    <asp:TemplateField HeaderText="Price"></asp:TemplateField>
                    <asp:TemplateField HeaderText="Volume"></asp:TemplateField>
                    <asp:TemplateField HeaderText="News"></asp:TemplateField>
            </Columns>
                <EmptyDataRowStyle Font-Names="Arial" Font-Size="11pt" ForeColor="White" />
            <HeaderStyle CssClass="headerstyle" Wrap="True" />
            <RowStyle CssClass="rowstyle" Wrap="False" />                      
        </asp:GridView></div>
       <br />
    </form>
</body>
</html>


