﻿<%@ Page Trace="false" Language="C#" AutoEventWireup="false" CodeFile="JQGrid.aspx.cs" Inherits="JQGrid" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>Ordinary JQuery Grid</title>

    <link href="css/table.css" rel="stylesheet" type="text/css" />
    <link href="css/ui.jqgrid.css" rel="stylesheet" type="text/css" media="screen" />
    <link href="css/ui-darkness/jquery-ui-1.8.4.custom.css" rel="stylesheet" type="text/css" />
          
    <script src="JQGrid/jquery-1.4.2.js" type="text/javascript"></script>
    <script src="JQGrid/grid.locale-en.js" type="text/javascript"></script>
    <script src="JQGrid/jquery.jqGrid.min.js" type="text/javascript"></script>
    <script src="JQGrid/json2-min.js" type="text/javascript"></script>

    <script src="JQGrid/lib/demo.js" type="text/javascript"></script>

    <style type="text/css" media="screen">
    th.ui-th-column div{
        white-space:normal !important;
        height:auto !important;
        padding:2px;
    }
    </style>
    <style type="text/css">
        .row_red
        {
            color: Red !important;
        }
        .row_lime
        {
            color: Lime !important;
        }
    </style>    
    <style type="text/css">
        body, html
        {
            font-family: arial;
            font-size: 11pt;
        }
    </style>

    <script type="text/javascript">

        var curID = 0;
        var maxRowHigh = 10;

        function Log(Text, MessageType) {
            if ((document.getElementById("LogContainer") == undefined)) { return; }
            if (MessageType == "OK") Text = "<span style='color: white;'>" + Text + "</span>";
            if (MessageType == "ERROR") Text = "<span style='color: red;'>" + Text + "</span>";           
            document.getElementById("LogContainer").innerHTML = Text + "<br />";
            var LogContainer = document.getElementById("LogContainer");
            LogContainer.scrollTop = LogContainer.scrollHeight;
        };

        function setIPAddress(responseText) {
            document.getElementById("iplabel").innerText = "IP Address: " + responseText;
        }

        function fnStartClock() {
            oInterval = setInterval("CallWebServiceFromJquery()", 1000);
        }

        function fnStopClock() {
            clearInterval(oInterval);
        }

        function CallWebServiceFromJquery() {
            $.ajax({
                type: "POST",
                url: "WebService.asmx/Tick",
                data: "{  }",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: OnSuccess,
                error: OnError
            });

        }

        function OnSuccess(data, status) {
            //alert(data.d);
            messages = data.d;
            for (var i = 0; i < messages.length; i++) {
                var ret = jQuery.parseJSON(messages[i]);
                ret.ImageID = '<img src="icons_grid/' + ret.ImageID + '.gif" />';
                curID = curID + 1;
                jQuery("#gvData").jqGrid('addRowData', curID, ret, "first");
                if (curID > maxRowHigh) {
                    jQuery("#gvData").jqGrid('delRowData', curID - maxRowHigh);
                }
            }
        }

        function OnError(request, status, error) {
            alert(request.statusText);
        }

        $(document).ready(function () {
            fnStartClock();
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="blank" 
        style="font-family: Arial, Helvetica, sans-serif; font-size: x-large; font-weight: bold; color: #FFFFFF">Ordinary JQuery Grid 
        with JSON</div>
    <div id="LogContainer"></div>
    <br />
		<div class="grid-header" style="width:100%">
			<div id="iplabel">IP Address: 127.0.0.1</div>
		</div>
        <table id="gvData" class="screen">
        </table>
    <br />
    </form>
</body>
</html>


