﻿using System;
using System.Collections.Generic;
using System.Web.Services;

/// <summary>
/// Summary description for WebService
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
[System.Web.Script.Services.ScriptService]
public class WebService : System.Web.Services.WebService {

    public WebService () {

        //Uncomment the following line if using designed components 
        //InitializeComponent(); 
    }

    const string SYMBOLS = @"ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private object _syncLock = new object();
    public string ID { get; set; }
    public string Token { get; set; }

    [WebMethod]
    public string[] Tick()
    {
        lock (_syncLock)
        {
            List<string> data = new List<string>();
            string jData = RandomDataToJson();
            data.Add(jData);
            return data.ToArray();
        }
    }

    public string RandomDataToJson()
    {
        lock (_syncLock)
        {
            char[] charArray = new char[3];
            string charPool = string.Empty;
            charPool += SYMBOLS;
            for (int i = 0; i < charArray.Length; i++)
            {
                int index = RandomNumber(0, charPool.Length);
                charArray[i] = charPool[index];
            }
            string zSymbol = new string(charArray);
            int x = RandomNumber(1, 3);
            if (x > 2)
                x = 2;
            string sDirection = "▲";
            if (x < 2)
                sDirection = "▲";
            else
                sDirection = "▼";

            try
            {
                var ret = String.Format("{{" +
                    "\"ImageID\":\"{0}\"," +
                    "\"Dir\":\"{1}\"," +
                    "\"Time\":\"{2}\"," +
                    "\"Symbol\":\"{3}\"," +
                    "\"High\":\"{4}\"," +
                    "\"Low\":\"{5}\"," +
                    "\"Price\":\"{6}\"," +
                    "\"Volume\":\"{7}\"," +
                    "\"News\":\"{8}\"" +
                    "}}",
                    x.ToString(),                                       //ret["ImageID"] 
                    sDirection,                                         //ret["Direction"] 
                    String.Format("{0:G}", DateTime.Now.ToString()),    //ret["Time"] 
                    zSymbol,                                            //ret["Symbol"] 
                    RandomNumber(1, 333).ToString("#,##0.00"),          //ret["High"] 
                    RandomNumber(1, 23).ToString("#,##0.00"),           //ret["Low"] 
                    RandomNumber(43, 333).ToString("#,##0.00"),         //ret["Price"] 
                    RandomNumber(11111, 88888).ToString(),              //ret["Volume"] 
                    "<a href='http://www.GeminiGroupTV.com/' target='blank'>News</a>");    //ret["News"]

                return ret;
            }
            catch
            {
            }
        }
        return String.Empty;
    }

    public int RandomNumber(int min, int max)
    {
        Random random = new Random();
        return random.Next(min, max);
    }
    
}



/*
    public string[] Tick()
    {
        RandomStringGenerator rndStock = new RandomStringGenerator(123); 
        string FakSymbol = rndStock.NextString(3);
        List<string> data = new List<string>();

        MyRnd myrnd = new MyRnd();
        int x = RandomNumber(1, 3);
        if (x > 2) x = 2;
        string sDirection = "▲";
        if (x < 2)
            sDirection = "▲";
        else
            sDirection = "▼";
        String[] zarr = new String[]{ };
        zarr[0] = x.ToString();                       //zarr["ImageID"] 
        zarr[1] = sDirection;                         //zarr["Direction"] 
        zarr[2] = DateTime.Now.ToString();            //zarr["Time"] 
        zarr[3] = rndStock.NextString(3);             //zarr["Symbol"] 
        zarr[4] = RandomNumber(4, 17).ToString();     //zarr["High"] 
        zarr[5] = RandomNumber(8, 23).ToString();     //zarr["Low"] 
        zarr[6] = RandomNumber(43, 58).ToString();    //zarr["Price"] 
        zarr[7] = RandomNumber(22, 56).ToString();    //zarr["Volume"] 
        zarr[8] = RandomNumber(11, 54).ToString();    //zarr["Value"] 
        zarr[9] = RandomNumber(33, 77).ToString();    //zarr["RealTimeVolumeRatio"] 
        zarr[10] = RandomNumber(1, 99).ToString();    //zarr["SignalSeconds"] 
        zarr[11] = RandomNumber(1, 99).ToString();    //zarr["LastNewsTime"] 
        zarr[12] = RandomNumber(1, 99).ToString();    //zarr["LastPrice"] 
        zarr[13] = RandomNumber(1, 99).ToString();    //ret["NetChange"]

        string jData = string.Empty; 

        try
        {
            jData = String.Format("{{" +
                "\"ImageID\":\"{0}\"," +
                "\"Dir\":\"{1}\"," +
                "\"Time\":\"{2}\"," +
                "\"Symbol\":\"{3}\"," +
                "\"High\":\"{4}\"," +
                "\"Low\":\"{5}\"," +
                "\"Price\":\"{6}\"," +
                "\"Volume\":\"{7}\"," +
                "\"Value\":\"{8}\"," +
                "\"RealTimeVolumeRatio\":\"{9}\"," +
                "\"SignalSeconds\":\"{10}\"," +
                "\"LastNewsTime\":\"{11}\"," +
                "\"LastPrice\":\"{12}\"," +
                "\"NetChange\":\"{13}\"" +
                "}}",

                zarr[0],    //ret["ImageID"] 
                zarr[1],    //ret["Direction"] 
                zarr[2],    //ret["Time"] 
                zarr[3],    //ret["Symbol"] 
                zarr[4],    //ret["High"] 
                zarr[5],    //ret["Low"] 
                zarr[6],    //ret["Price"] 
                zarr[7],    //ret["Volume"] 
                zarr[8],    //ret["Value"] 
                zarr[9],    //ret["RealTimeVolumeRatio"] 
                zarr[10],    //ret["SignalSeconds"] 
                zarr[11],    //ret["LastNewsTime"] 
                zarr[12],    //ret["LastPrice"] 
                zarr[13]);    //ret["NetChange"]

        }
        catch
        {
        }
        data.Add(jData);
        return data.ToArray();
    }
*/