﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="DropdownFilter.aspx.cs" Inherits="DropdownFilter" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <script type="text/javascript" src="JQuery/jquery-1.4.1.js"></script>
    <script type="text/javascript" src="JQuery/jquery.uitablefilter.js"></script>

    <script language="javascript">
        $(document).ready(function() {
            //Hide div that has the check box list
            $("#dvProductsHolder").hide();

            //Show check box list when user clicks on the textbox, just below the textbox.
            $("#filter").click(function() {
                $('#dvProductsHolder').css("top", $(this).offset().top + $(this).height() + 5);
                $('#dvProductsHolder').css("left", $(this).offset().left - 9);
                $("#dvProductsHolder").slideDown("slow");
            });

            //Get the instance of the table, on which you want to integrate the table filter
            var theTable = $("#tableProducts")

            //Invoke uiTableFilter plugin on keyup event of the filter textbox
            $("#filter").keyup(function() {
                $.uiTableFilter(theTable, this.value);
            })

            //Select/deselect all checkbox list when "ALL" is cliecked
            $("#chkAll").click(function() {
                var obj = $(this);

                if (obj[0].checked == true) {
                    $("input[type='checkbox']").each(function() {
                        $(this)[0].checked = true;
                    });
                }
                else {
                    $("input[type='checkbox']").each(function() {
                        $(this)[0].checked = false;
                    });
                }
            });

            //Hide the filter list on mouse leave and populate the hidden variable with 
            //the values selected in the check box list
            $("#dvProductsHolder").mouseleave(
	 	        function() {
	 	            var selectedValues = '';
	 	            $("input[type='checkbox']").each(function() {
	 	                if ($(this)[0].checked) {
	 	                    selectedValues = selectedValues + $("#" + $(this)[0].id).next().text() + ";";
	 	                }
	 	            });
	 	            $("#hdnSelectedValues").val(selectedValues);
	 	            $("#dvProductsHolder").slideUp("slow");
	 	        }
	        );
        });
    </script>

    <style type="text/css">
        #dvProductsHolder
        {
            width: 290px;
            padding: 0px;
            margin: 0px;
            position: absolute;
            display: none;
            border-right: #C40000 1px solid;
            padding-right: 8px;
            border-top: #C40000 1px solid;
            padding-left: 8px;
            margin-left: 8px;
            border-left: #C40000 1px solid;
            border-bottom: #C40000 1px solid;
            max-height: 200px;
            overflow: scroll;
        }
        .serach
        {
            width: 300px;
            background: url(images/search.gif) #ffffff no-repeat right 50%;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <asp:HiddenField runat="server" ID="hdnSelectedValues" />
    <div>
        Filter:
        <asp:TextBox ID="filter" CssClass="serach" runat="server" Text="" MaxLength="30"></asp:TextBox>
        <asp:Button runat="server" ID="btnSearch" Text="Go" OnClick="btnSearch_Click" />
        <div id="dvProductsHolder">
            <table id="tableProducts" cellpadding="0" cellspacing="0">
                <tr style="background-color: #C5BBAF; padding-bottom: 20px">
                    <td>
                        <asp:CheckBox runat="server" ID="chkAll" />ALL
                    </td>
                </tr>
                <asp:Repeater ID="GridView1" runat="server">
                    <AlternatingItemTemplate>
                        <tr style="background-color: White; padding: 2px">
                            <td>
                                <asp:CheckBox runat="server" ID="chkProduct" Text='<%# Bind("Name")%>' />
                            </td>
                        </tr>
                    </AlternatingItemTemplate>
                    <ItemTemplate>
                        <tr style="background-color: #E3EAEB; padding: 2px">
                            <td>
                                <asp:CheckBox runat="server" ID="chkProduct" Text='<%# Bind("Name")%>' />
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </table>
        </div>
        <div id="Div1" runat="server">
            <asp:Label runat="server" ID="lblSelectedValues"></asp:Label>
        </div>
    </div>
    </form>
</body>
</html>
