Imports Microsoft.VisualBasic
Imports CrystalDecisions.CrystalReports.Engine
Imports CrystalDecisions.Shared

Public Class clsCRExport
    Inherits System.Web.UI.Page

    Public Function CRExportReport(ByVal sel As clsSelect) As String

        'Remember change the reg. key to -1 if needed 
        'HKEY_LOCAL_MACHINE\SOFTWARE\Crystal Decisions\10.2\Report Application Server\ InprocServer\PrintJobLimit

        'Get the temporary file name
        Dim sTempFileName As String = System.IO.Path.GetTempFileName

        Dim ContentType As String = ""

        Try
            Dim Report As New ReportDocument
            'Load the report
            Report.Load(System.AppDomain.CurrentDomain.BaseDirectory() & sel.ReportSource)

            'Get the selection formula if there is one
            If Len(sel.SelectionFormula) > 1 Then
                Report.RecordSelectionFormula = sel.SelectionFormula
            End If

            'Set the file options, temporary file name and content type
            Dim FileOption As New DiskFileDestinationOptions
            FileOption.DiskFileName = sTempFileName

            Dim Options As New ExportOptions
            Options.ExportDestinationOptions = FileOption
            Options.ExportDestinationType = ExportDestinationType.DiskFile

            Select Case sel.ReportExportType

                Case ExportType.ExcelRecord
                    Options.ExportFormatType = ExportFormatType.ExcelRecord
                    Report.ExportToDisk(ExportFormatType.ExcelRecord, sTempFileName)
                    ContentType = "application/vnd.ms-excel"

                Case ExportType.Excel
                    Options.ExportFormatType = ExportFormatType.Excel
                    Report.ExportToDisk(ExportFormatType.Excel, sTempFileName)
                    ContentType = "application/vnd.ms-excel"

                Case ExportType.Pdf
                    Options.ExportFormatType = ExportFormatType.PortableDocFormat
                    Report.ExportToDisk(ExportFormatType.PortableDocFormat, sTempFileName)
                    ContentType = "application/pdf"

                Case ExportType.MSWord
                    Options.ExportFormatType = ExportFormatType.WordForWindows
                    Report.ExportToDisk(ExportFormatType.WordForWindows, sTempFileName)
                    ContentType = "application/msword"

            End Select

            'Write the file to the web page
            System.Web.HttpContext.Current.Response.ClearContent()
            System.Web.HttpContext.Current.Response.ClearHeaders()

            System.Web.HttpContext.Current.Response.ContentType = ContentType
            System.Web.HttpContext.Current.Response.WriteFile(sTempFileName)

            'Clean up the response object
            System.Web.HttpContext.Current.Response.Flush()
            System.Web.HttpContext.Current.Response.Close()

            'IMPORTANT do the garbage collection
            Report.Dispose()
            FileOption = Nothing
            Options = Nothing

            System.IO.File.Delete(sTempFileName)



        Catch ex As Exception
            System.Diagnostics.Debug.Print(ex.ToString)
            Return ex.ToString
        End Try

        Return "OK"

    End Function
End Class
