﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using JqueryController;

public partial class _Default : PageBase
{
    Employee emp = new Employee();
    protected void Page_Load(object sender, EventArgs e)
    {


        if (this.IsPartialRendering)
        {
            if (this.PostParameter.ContainsKey("action")) {
                string action = this.PostParameter["action"];
                switch (action) { 
                    case "add":
                        emp.AddOneEmployee();
                        break;
                    case "remove":
                        emp.RemoveTheLastEmployee();
                        break;
                }            
                BindDataGrid(emp.GetAllEmployee());             
            
            }
            if (this.PostParameter.ContainsKey("selectedId"))
            {
                int selectedId = int.Parse(this.PostParameter["selectedId"]);
                SelectEmployees(selectedId);
            }
        }
       
        
    
        
    }

    private void BindDataGrid(IEnumerable<Employee> datasource) {
        GridUserControl1.GridDetails.DataSource = datasource;
        GridUserControl1.GridDetails.DataBind();
        JqueryControllerGrid.RefreshPanel("parameterBack");
    }


   

    private void SelectEmployees(int selectedId) { 
        switch(selectedId){

            case 0:
                BindDataGrid(emp.GetAllEmployee());              
                break;
        case 1:
                BindDataGrid(emp.GetAllEmployee().Where(x => x.ID > 30));
            break;
             
            case 2:
             BindDataGrid(emp.GetAllEmployee().Where(x => x.ID < 30));
            break;

        }
      
    }

  
}