using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using GoogleMap;
using System.Collections.Generic;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        { 
            GoogleMap1.MapInfo.Latitude = 41.0191048232402;
            GoogleMap1.MapInfo.Longtitude = 28.997393828418;
            GoogleMap1.MapInfo.Zoom = 12;
            GoogleMap1.MapInfo.MapType = MapTypes.ROADMAP;
            GoogleMap1.Width = 700;
            GoogleMap1.Height = 500;
        }

        //GoogleMap1.MapCenterChanged += new GoogleMap.MapCenterChangedEventHandler(GoogleMap1_MapCenterChanged);
        GoogleMap1.MapClicked += new MapClickedEventHandler(GoogleMap1_MapClicked);
    }

    void GoogleMap1_MapClicked(double Latitude, double Longtitude)
    {
        Marker m = new Marker(Guid.NewGuid().ToString(), Latitude, Longtitude, "images/marker1.ico");
        m.Draggable = true;
        m.InfoWindowOnClick = true;
        m.InfoWindowContentHtml = "New Marker Content Html, Added at: " + DateTime.Now.ToString();

        GoogleMap1.Markers.Add(m);
    }
   
    protected void btnStart_Click(object sender, EventArgs e)
    {
        Marker m = new Marker();
        m.ImgSrc = "images/marker2.ico";

        m.ImgW = 32;
        m.ImgH = 32;

        GoogleMap1.PlayRouteMap(MapData.RouteMapInfo, 700, m);
    }

    //just postback..
    protected void btnStop_Click(object sender, EventArgs e)
    {

    }
}
