﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;

/// <summary>
/// Summary description for Utilities
/// </summary>
public sealed class Utilities
{
    private static volatile Utilities instance;
    private static object syncRoot = new Object();

    private Utilities() {}

    public static Utilities Instance
    {
        get
        {
            if (instance == null)
            {
                lock (syncRoot)
                {
                    if (instance == null)
                        instance = new Utilities();
                }
            }

            return instance;
        }
    }

    public string SliderRangeXMLPath
    {
        get { return ConfigurationManager.AppSettings["SliderRange"] as string; }
    }

    public string CarsListXMLPath
    {
        get { return ConfigurationManager.AppSettings["CarsList"] as string; }
    }

}
