﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class _Default : System.Web.UI.Page
{
        
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // Bind the categories with Grid
                BindCategories(string.Empty);
                // This is used to bind the textbox header with the event to fire when 
                ((TextBox)this.gvCategory.HeaderRow.Cells[1].Controls[1]).TextChanged += new System.EventHandler(this.txtCategoryNameHeader_TextChanged);
            }
        }
        private void BindCategories(string CategoryFilter)
        {
            
            try
            {
                // Simple created a table to bind with Grid view and populated it with data.
                DataTable dt = new DataTable("Category");
                dt.Columns.Add("ID");
                dt.Columns.Add("Name");
                DataRow dr ;
                for(int counter=1;counter<11;counter++)
                {
                    dr = dt.NewRow();
                    dr["ID"]=counter.ToString();
                    dr["Name"]= "Cat" + counter.ToString();
                    dt.Rows.Add(dr);
                }

                DataView dv = new DataView(dt);
                if(CategoryFilter != "")
                    dv.RowFilter="Name like '%" + CategoryFilter + "%'";                    


                if (CategoryFilter == "")
                    gvCategory.DataSource = dv;
                else
                    gvCategory.DataSource = dv;
                gvCategory.DataBind();
            }
            catch (Exception ex)
            {

            }
            finally
            {
                
            }
        }
        
        protected void txtCategoryNameHeader_TextChanged(object sender, EventArgs e)
        {
            string text = ((TextBox)sender).Text;
            BindCategories(text);
        }

      

       
    
}
