using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI.Design;
using System.ComponentModel;
using System.Web.UI.Design.WebControls;
using System.Drawing;
using System.ComponentModel.Design;
using System.Drawing.Design;
using System.Web.UI;

namespace LoadingControl
{
    public class LoadingDesigner : ControlDesigner
    {
        /// <summary>
        /// For Design time view of the control
        /// </summary>        
        public override string GetDesignTimeHtml()
        {
            string template = "<table cellpadding=4 cellspacing=0 style=\"font:messagebox;color:buttontext;background-color:buttonface;border: solid 1px;border-top-color:buttonhighlight;border-left-color:buttonhighlight;border-bottom-color:buttonshadow;border-right-color:buttonshadow\"><tr><td nowrap><span style=\"font-weight:bold\">{0}</span> - {1}</td></tr><tr><td>{2}</td></tr></table>";

            string markup = String.Format(template,
                base.Component.GetType().Name,
                base.Component.Site.Name,
                base.GetDesignTimeHtml());
            return markup;
        }

        /// <summary>
        /// List of actions to be shown in designer
        /// </summary>
        public override DesignerActionListCollection ActionLists
        {
            get
            {
                DesignerActionListCollection list = new DesignerActionListCollection();
                list.AddRange(base.ActionLists);
                list.Add(new LoadingActionList(this));
                return list;
            }
        }

        /// <summary>
        /// To hide few properties inherited from base control in the property grid
        /// Customized to provide full design support to control
        /// </summary>
        /// <param name="properties">Properties that need to be modified</param>
        protected override void PreFilterProperties(System.Collections.IDictionary properties)
        {
            base.PreFilterProperties(properties);
            string[] propertiesToHide = { "Enabled", "EnableTheming", "EnableViewState", "SkinID", "BorderColor", "BorderStyle", "BorderWidth", "CssClass", "Height", "Width", "Visible", "TabIndex" };
            PropertyDescriptor objPropDescriptor;
            foreach (string propertyName in propertiesToHide)
            {
                objPropDescriptor = (PropertyDescriptor)properties[propertyName];
                if (objPropDescriptor != null)
                {
                    System.ComponentModel.AttributeCollection runtimeAttributes = objPropDescriptor.Attributes;
                    Attribute[] attrs = new Attribute[runtimeAttributes.Count + 1];
                    runtimeAttributes.CopyTo(attrs, 0);
                    attrs[runtimeAttributes.Count] = new BrowsableAttribute(false);
                    objPropDescriptor = TypeDescriptor.CreateProperty(this.GetType(), propertyName, objPropDescriptor.PropertyType, attrs);
                    properties[propertyName] = objPropDescriptor;
                }
            }
        }
    }

    #region CLASS::LoadingActionList
    public class LoadingActionList : DesignerActionList
    {
        #region Private variables
        private LoadingDesigner _designer;
        private Loading _loadingControl;
        #endregion

        #region Constructor
        /// <summary>
        /// Constructor
        /// </summary>        
        public LoadingActionList(LoadingDesigner parent)
            : base(parent.Component)
        {
            _designer = parent;
            _loadingControl = (Loading)_designer.Component;
        } 
        #endregion

        #region Overridden methods
        /// <summary>
        /// Populate Action List to be shown in designer
        /// </summary>        
        public override DesignerActionItemCollection GetSortedActionItems()
        {
            string allRegionsCategory = "Appearance";

            DesignerActionItemCollection items = new DesignerActionItemCollection();
            items.Add(new DesignerActionHeaderItem("Appearance", allRegionsCategory));
            items.Add(new DesignerActionPropertyItem("LoadingText", "Loading Text", allRegionsCategory,
                "Text to be displayed while loading"));
            items.Add(new DesignerActionPropertyItem("LoadingImagePath", "Image Path", allRegionsCategory,
                "Image path of the image to be displayed while loading"));

            items.Add(new DesignerActionHeaderItem("Control Orientation", allRegionsCategory));
            items.Add(new DesignerActionPropertyItem("HorizontalAlignment", "Horizontal Alignment", allRegionsCategory,
                "Horizontal alignment of the control"));
            items.Add(new DesignerActionPropertyItem("VerticalAlignment", "Vertical Alignment", allRegionsCategory,
                "Vertical alignment of the control"));

            items.Add(new DesignerActionHeaderItem("Text Orientation", allRegionsCategory));
            items.Add(new DesignerActionPropertyItem("TextVAlignment", "Vertical Alignment", allRegionsCategory,
                "Vertical alignment of the text in the control"));
            items.Add(new DesignerActionPropertyItem("TextLocation", "Location", allRegionsCategory,
                "Location of the text relative to image in the control"));

            return items;
        } 
        #endregion

        #region Properties
        public string LoadingText
        {
            get
            {
                return _loadingControl.LoadingText;
            }
            set
            {
                PropertyDescriptor pd = TypeDescriptor.GetProperties(_loadingControl)["LoadingText"];
                if (pd != null)
                    pd.SetValue(_loadingControl, value);
            }
        }

        [UrlProperty]
        [Editor(typeof(UrlEditor), typeof(UITypeEditor))]
        public string LoadingImagePath
        {
            get
            {
                return _loadingControl.LoadingImagePath;
            }
            set
            {
                PropertyDescriptor pd = TypeDescriptor.GetProperties(_loadingControl)["LoadingImagePath"];
                if (pd != null)
                    pd.SetValue(_loadingControl, value);

            }
        }

        public Loading.HAlignmentValues HorizontalAlignment
        {
            get
            {
                return _loadingControl.HorizontalAlignment;
            }
            set
            {
                PropertyDescriptor pd = TypeDescriptor.GetProperties(_loadingControl)["HorizontalAlignment"];
                if (pd != null)
                    pd.SetValue(_loadingControl, value);

            }
        }

        public Loading.VAlignmentValues VerticalAlignment
        {
            get
            {
                return _loadingControl.VerticalAlignment;
            }
            set
            {
                PropertyDescriptor pd = TypeDescriptor.GetProperties(_loadingControl)["VerticalAlignment"];
                if (pd != null)
                    pd.SetValue(_loadingControl, value);

            }
        }

        public Loading.VAlignmentValues TextVAlignment
        {
            get
            {
                return _loadingControl.TextVAlignment;
            }
            set
            {
                PropertyDescriptor pd = TypeDescriptor.GetProperties(_loadingControl)["TextVAlignment"];
                if (pd != null)
                    pd.SetValue(_loadingControl, value);

            }
        }

        public Loading.RelativeTextLocation TextLocation
        {
            get
            {
                return _loadingControl.TextLocation;
            }
            set
            {
                PropertyDescriptor pd = TypeDescriptor.GetProperties(_loadingControl)["TextLocation"];
                if (pd != null)
                    pd.SetValue(_loadingControl, value);

            }
        } 
        #endregion
    }
    #endregion

}