﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Web.UI;

namespace BannerRotatorControl
{
    [TypeConverter(typeof(ExpandableObjectConverter))]
    public class BannerDisplayCheck
    {
        public enum CriteriaTypes
        {
            PageURL, QueryString, Session, Cookie, UserDefined
        }

        protected CriteriaTypes _criteraType = CriteriaTypes.PageURL;
        protected string _CriteriaName = null;



        public BannerDisplayCheck()
            : this(CriteriaTypes.PageURL, string.Empty)
        {
        }

        public BannerDisplayCheck(CriteriaTypes CriteriaType, string Name)
        {
            _criteraType = CriteriaType;
             _CriteriaName = Name;
             
           

        }





        [
        Category("Behavior"),
        DefaultValue(""),
        Description("List of Different types of parameters: PageURL, QuertString,  Session, Cookie"),
        NotifyParentProperty(true),
        ]
        public CriteriaTypes ParameterType
        {
            get
            {
                return _criteraType;
            }
            set
            {
                _criteraType = value;
            }
        }


        [
      Category("Behavior"),
      DefaultValue(""),
      Description("ParameterName: exmaple: Name of the QueryString, Session,Coookie"),
      NotifyParentProperty(true)
      ]
        public string ParameterName
        {
            get
            {
                return _CriteriaName;
            }
            set
            {
                _CriteriaName = value;
               
            }
        }



    }

}