﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace DataPagerRepeater
{

    [ToolboxData("<{0}:DataPagerRepeater runat=server PersistentDataSource=true></{0}:DataPagerRepeater>")]

    public class DataPagerRepeater : Repeater, System.Web.UI.WebControls.IPageableItemContainer, INamingContainer
    {



        public int MaximumRows { get { return ViewState["_maximumRows"] != null ? (int)ViewState["_maximumRows"] : -1; } }

        public int StartRowIndex { get { return ViewState["_startRowIndex"] != null ? (int)ViewState["_startRowIndex"] : -1; } }

        public int TotalRows { get { return ViewState["_totalRows"] != null ? (int)ViewState["_totalRows"] : -1; } }

        public bool PersistentDataSource
        {

            get { return ViewState["PersistentDataSource"] != null ? (bool)ViewState["PersistentDataSource"] : true; }

            set { ViewState["PersistentDataSource"] = value; }

        }

        protected override void LoadViewState(object savedState)
        {

            base.LoadViewState(savedState);

            if (Page.IsPostBack)
            {

                if (PersistentDataSource && ViewState["DataSource"] != null)
                {

                    this.DataSource = ViewState["DataSource"];

                    this.DataBind();

                }

            }

        }



        public void SetPageProperties(int startRowIndex, int maximumRows, bool databind)
        {

            ViewState["_startRowIndex"] = startRowIndex;

            ViewState["_maximumRows"] = maximumRows;

            if (TotalRows > -1)
            {

                if (TotalRowCountAvailable != null)
                {

                    TotalRowCountAvailable(this, new PageEventArgs((int)ViewState["_startRowIndex"], (int)ViewState["_maximumRows"], TotalRows));

                }

            }

        }



        protected override void OnDataPropertyChanged()
        {

            if (MaximumRows != -1)
            {

                this.RequiresDataBinding = true;

            }

            else

                base.OnDataPropertyChanged();

        }



        protected override void RenderChildren(HtmlTextWriter writer)
        {

            if (MaximumRows != -1)
            {

                foreach (RepeaterItem item in this.Items)
                {

                    if (item.ItemType == ListItemType.Item || item.ItemType == ListItemType.AlternatingItem)
                    {

                        item.Visible = false;

                        if (item.ItemIndex >= (int)ViewState["_startRowIndex"] && item.ItemIndex <= ((int)ViewState["_startRowIndex"] + (int)ViewState["_maximumRows"]))
                        {

                            item.Visible = true;

                        }

                    }

                    else
                    {

                        item.Visible = true;

                    }

                }

            }

            base.RenderChildren(writer);

        }



        public override void DataBind()
        {



            base.DataBind();

            if (MaximumRows != -1)
            {

                int i = 0;

                foreach (object o in GetData())
                {

                    i++;

                }

                ViewState["_totalRows"] = i;

                if (PersistentDataSource)

                    ViewState["DataSource"] = this.DataSource;

                SetPageProperties(StartRowIndex, MaximumRows, true);

            }



        }

        protected override System.Collections.IEnumerable GetData()
        {

            return base.GetData();

        }

        public event System.EventHandler<PageEventArgs> TotalRowCountAvailable;

    }

}
