﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

public partial class Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
            BindData();
    }
    protected void SearchGridView1_SearchGrid(string _strSearch)
    {
        hfSearchText.Value = _strSearch;
        BindData();
    }
    void BindData()
    {
        //hfSearchText has the search string returned from the grid.
        if (hfSearchText.Value != "")
            dsCustomers.SelectCommand += " where " + hfSearchText.Value;
        DataView dv = (DataView)dsCustomers.Select(new DataSourceSelectArguments());
        //hfSort has the sort string returned from the grid.
        if (hfSort.Value != "")
            dv.Sort = hfSort.Value;

        SearchGridView1.DataSource = dv;
        try
        {
            SearchGridView1.DataBind();
        }
        catch (Exception exp)
        {
            //If databinding threw exception bcoz current page index is > than available page index
            SearchGridView1.PageIndex = 0;
            SearchGridView1.DataBind();
        }
        finally
        {
            //Select the first row returned
            if (SearchGridView1.Rows.Count > 0)
                SearchGridView1.SelectedIndex = 0;
        }

    }

    protected void SearchGridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        SearchGridView1.PageIndex = e.NewPageIndex;
        BindData();
    }
    protected void SearchGridView1_Sorting(object sender, GridViewSortEventArgs e)
    {
        //If hfSort has the same value as before, the sorting should be done in descending order
        if (hfSort.Value == e.SortExpression)
            hfSort.Value = e.SortExpression + " Desc";
        else
            hfSort.Value = e.SortExpression;
        BindData();
    }

}
