﻿using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        BindData();
    }
    protected void gvMaster_PreRender(object sender, EventArgs e)
    {
        foreach (GridViewRow row in gvMaster.Rows)
        {
                ImageButton img = (ImageButton)row.FindControl("imgButSel");
                GridView gv = (GridView)row.FindControl("gvChild");
                SqlDataSource dsChild = (SqlDataSource)row.FindControl("dsChild");
                if(dsChild != null)
                    dsChild.SelectParameters[0].DefaultValue = row.Cells[3].Text;

                if (gv != null)
                {
                    if(!gv.Visible)
                    {
                        if (img != null)
                            img.ImageUrl = "~/images/noselect.gif";
                    }
                    else
                    {
                        BindChildData(gv);
                        if (img != null)
                            img.ImageUrl = "~/images/select.gif";
                    }
                }
        }
    }
    protected void gvMaster_SearchGrid(object sender, string _strSearch)
    {
        if (_strSearch != null && _strSearch.ToUpper().StartsWith("CATEGORYID "))
            _hfSearch.Value = _strSearch.ToUpper().Replace("CATEGORYID ", "Convert(CATEGORYID, 'System.String') ");
        else
            _hfSearch.Value = _strSearch;
        BindData();
    }
    void BindData()
    {
        dsMaster.FilterExpression = _hfSearch.Value;
        dsMaster.Select(new DataSourceSelectArguments());
    }

    protected void gvMaster_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int intCatID = (int)e.Keys[0];        
        SqlConnection connection = new SqlConnection(ConfigurationManager.ConnectionStrings["NorthWindCSConnectionString"].ConnectionString);
        SqlCommand command = new SqlCommand("select * from Products where CategoryID = " + intCatID, connection);
        try
        {
            connection.Open();
            SqlDataReader reader = command.ExecuteReader();
            if (reader.Read())
            {
                ScriptManager.RegisterStartupScript(Page, GetType(), Guid.NewGuid().ToString(), "alert('Category cannot be deleted since it has prodcuts inside it.');", true);
                e.Cancel = true;
                return;
            }
        }
        catch (Exception exp)
        {
            ScriptManager.RegisterStartupScript(Page, GetType(), Guid.NewGuid().ToString(), "alert('SQLException : "+exp.Message+"');", true);
            e.Cancel = true;
            return;
        }
        finally
        {
            connection.Close();
        }

        dsMaster.DeleteParameters["CategoryID"].DefaultValue = intCatID.ToString();
        dsMaster.Delete();
        ScriptManager.RegisterStartupScript(Page, GetType(), Guid.NewGuid().ToString(), "alert('Category successfully deleted.');", true);
    }
    protected void gvChild_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string strProdId = e.Keys[0].ToString();        
        SqlConnection connection = new SqlConnection(ConfigurationManager.ConnectionStrings["NorthWindCSConnectionString"].ConnectionString);
        SqlCommand command = new SqlCommand("select * from [Order Details] where productid = '" + strProdId + "'", connection);
        try
        {
            connection.Open();
            SqlDataReader reader = command.ExecuteReader();
            if (reader.Read())
            {                
                ScriptManager.RegisterStartupScript(Page,GetType(), Guid.NewGuid().ToString(), "alert('Product cannot be deleted since it has orders raised against it.');", true);
                e.Cancel = true;
                return;
            }
        }
        catch (Exception exp)
        {
            ScriptManager.RegisterStartupScript(Page, GetType(), Guid.NewGuid().ToString(), "alert('SQLException : " + exp.Message + "');", true);
            e.Cancel = true;
            return;
        }
        finally
        {
            connection.Close();
        }

        GridViewRow gvr = (GridViewRow)((GridView)sender).NamingContainer;
        SqlDataSource dsChild = (SqlDataSource)gvr.FindControl("dsChild");

        dsChild.DeleteParameters["productid"].DefaultValue = strProdId;
        dsChild.Delete();
        ScriptManager.RegisterStartupScript(Page, GetType(), Guid.NewGuid().ToString(), "alert('Product successfully deleted.');", true);
        
    }
    void BindChildData(GridView gv)
    {
        GridViewRow gvr = (GridViewRow)gv.NamingContainer;
        HiddenField _hfChildSearch = (HiddenField)gvr.FindControl("_hfChildSearch");
        SqlDataSource dschild = (SqlDataSource)gvr.FindControl("dsChild");
        dschild.FilterExpression = _hfChildSearch.Value;
        dschild.Select(new DataSourceSelectArguments());
        gv.DataBind();
        if (gv.Rows.Count > 0)
           gv.SelectedIndex = 0;
    }

    protected void gvChild_SearchGrid(object sender, string _strSearch)
    {
        GridViewRow gvr = (GridViewRow)((GridView)sender).NamingContainer;
        HiddenField _hfChildSearch = (HiddenField)gvr.FindControl("_hfChildSearch");
        if (_strSearch != null && _strSearch.ToUpper().StartsWith("PRODUCTID "))
            _hfChildSearch.Value = _strSearch.ToUpper().Replace("PRODUCTID ", "Convert(PRODUCTID, 'System.String') ");
        else
            _hfChildSearch.Value = _strSearch;
        BindChildData((GridView)sender);
    }
    protected void gvMaster_SelectedIndexChanged(object sender, EventArgs e)
    {
    }
    protected void gvMaster_PageIndexChanged(object sender, EventArgs e)
    {
    }
    protected void gvChild_RowUpdated(object sender, GridViewUpdatedEventArgs e)
    {
        ScriptManager.RegisterStartupScript(Page, GetType(), Guid.NewGuid().ToString(), "alert('Product successfully updated.');", true);
    }
    protected void gvMaster_RowUpdated(object sender, GridViewUpdatedEventArgs e)
    {
         ScriptManager.RegisterStartupScript(Page, GetType(), Guid.NewGuid().ToString(), "alert('Category successfully updated.');", true);
    }
    protected void gvMaster_Sorted(object sender, EventArgs e)
    {
    }
    protected void gvMaster_AddRow(object sender)
    {
        _hfSearch.Value = "1 = 2";
        BindData();
    }
    protected void gvChild_AddRow(object sender)
    {
        GridViewRow gvr = (GridViewRow)((GridView)sender).NamingContainer;
        HiddenField _hfChildSearch = (HiddenField)gvr.FindControl("_hfChildSearch");
        _hfChildSearch.Value = "1 = 2";
        BindChildData((GridView)sender);
    }
    protected void gvMaster_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "InsertNew")
        {
            TextBox tbCatName = (TextBox)gvMaster.Controls[0].Controls[0].FindControl("tbCategoryName");
            TextBox tbDesc = (TextBox)gvMaster.Controls[0].Controls[0].FindControl("tbDescription");
            TextBox tbPictureUrl = (TextBox)gvMaster.Controls[0].Controls[0].FindControl("tbPictureUrl");

            if(tbCatName != null)
                dsMaster.InsertParameters["categoryName"].DefaultValue = tbCatName.Text;
            if(tbDesc != null)
                dsMaster.InsertParameters["description"].DefaultValue = tbDesc.Text;
            if (tbPictureUrl != null)
                dsMaster.InsertParameters["pictureurl"].DefaultValue = tbPictureUrl.Text;
            dsMaster.Insert();
            _hfSearch.Value = "";
            BindData();
        }
        if (e.CommandName == "InsertCancel")
        {
            _hfSearch.Value = "";
            BindData();
        }
    }
    protected void gvChild_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        GridViewRow gvr = (GridViewRow)((GridView)sender).NamingContainer;
        HiddenField _hfChildSearch = (HiddenField)gvr.FindControl("_hfChildSearch");
        SqlDataSource dsChild = (SqlDataSource)gvr.FindControl("dsChild");

        if (e.CommandName == "InsertNew")
        {
            TextBox tbProdName = (TextBox)((GridView)sender).Controls[0].Controls[0].FindControl("tbProductName");
            TextBox tbQPerunit = (TextBox)((GridView)sender).Controls[0].Controls[0].FindControl("tbQuantityPerUnit");
            TextBox tbUPrice = (TextBox)((GridView)sender).Controls[0].Controls[0].FindControl("tbUnitPrice");
            if (tbProdName != null)
                dsChild.InsertParameters["productName"].DefaultValue = tbProdName.Text;
            if (tbQPerunit != null)
                dsChild.InsertParameters["quantityPerUnit"].DefaultValue = tbQPerunit.Text;
            if (tbUPrice != null)
                dsChild.InsertParameters["unitPrice"].DefaultValue = tbUPrice.Text;
            dsChild.InsertParameters["categoryId"].DefaultValue = gvr.Cells[3].Text;
            dsChild.InsertParameters["discontinued"].DefaultValue = bool.FalseString;
            dsChild.Insert();
            _hfChildSearch.Value = "";
            BindChildData((GridView)sender);
        }
        if (e.CommandName == "InsertCancel")
        {
            _hfChildSearch.Value = "";
            BindChildData((GridView)sender);
        }
    }
    protected void gvMaster_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        //if (gvMaster.Rows[e.NewSelectedIndex].FindControl("pnlChild") != null)
        //    gvMaster.Rows[e.NewSelectedIndex].FindControl("pnlChild").Visible = !gvMaster.Rows[e.NewSelectedIndex].FindControl("pnlChild").Visible;
    }
    protected void gvMaster_RowDataBound(object sender, GridViewRowEventArgs e)
    {
    }
}
