﻿using System;
using System.ComponentModel;
using System.Security.Permissions;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

[
AspNetHostingPermission(SecurityAction.Demand,
    Level = AspNetHostingPermissionLevel.Minimal),
AspNetHostingPermission(SecurityAction.InheritanceDemand,
    Level = AspNetHostingPermissionLevel.Minimal),
DefaultProperty("StartTitle"),
ToolboxData("<{0}:ThumbnailSet runat=\"server\"> </{0}:ThumbnailSet>")
]
public partial class Controls_ThumbnailSet : System.Web.UI.UserControl
{
    List<string> thumbFiles = null;    // filenames
    List<string> imgFiles = null;

    [
    Bindable(true),
    Category("Appearance"),
    DefaultValue(""),
    Description("The first title of the thumbnail set."),
    Localizable(true)
    ]
    public virtual string StartTitle
    {
        get
        {
            string s = (string)ViewState["StartTitle"];
            return (s == null) ? String.Empty : s;
        }
        set
        {
            ViewState["StartTitle"] = value;
            StartTitleLabel.Text = value;
        }
    }

    [
    Bindable(true),
    Category("Appearance"),
    DefaultValue(""),
    Description("The second title of the thumbnail set."),
    Localizable(true)
    ]
    public virtual string EndTitle
    {
        get
        {
            string s = (string)ViewState["EndTitle"];
            return (s == null) ? String.Empty : s;
        }
        set
        {
            ViewState["EndTitle"] = value;
            EndTitleLabel.Text = value;
        }
    }

    [
    Bindable(true),
    Category("Appearance"),
    DefaultValue(""),
    Description("Number of columns in one thumbnail row."),
    Localizable(true)
    ]
    public virtual int ColumnsPerRow
    {
        get
        {
            object s = (Int32)ViewState["ColumnsPerRow"];
            return (s == null) ? 3 : (Int32)s;
        }
        set
        {
            ViewState["ColumnsPerRow"] = value;
        }
    }

    [
    Bindable(true),
    Category("Appearance"),
    DefaultValue(""),
    Description("Spacing of cells in the thumbnail table."),
    Localizable(true)
    ]
    public virtual int ThumbCellSpacing
    {
        get
        {
            object s = (Int32)ViewState["ThumbCellSpacing"];
            return (s == null) ? ThumbTable.CellSpacing : (Int32)s;
        }
        set
        {
            ViewState["ThumbCellSpacing"] = value;
            ThumbTable.CellSpacing = value;
        }
    }

    [
    Bindable(true),
    Category("Appearance"),
    DefaultValue(""),
    Description("Padding of cells in the thumbnail table."),
    Localizable(true)
    ]
    public virtual int ThumbCellPadding
    {
        get
        {
            object s = (Int32)ViewState["ThumbCellPadding"];
            return (s == null) ? ThumbTable.CellPadding : (Int32)s;
        }
        set
        {
            ViewState["ThumbCellPadding"] = value;
            ThumbTable.CellPadding = value;
        }
    }

    [
    Bindable(true),
    Category("Behavior"),
    DefaultValue(""),
    Description("The directory where the thumbnails live."),
    Localizable(true)
    ]
    public virtual string ThumbSrc
    {
        get
        {
            string s = (string)ViewState["ThumbSrc"];
            return (s == null) ? String.Empty : s;
        }
        set
        {
            ViewState["ThumbSrc"] = value;
        }
    }

    [
    Bindable(true),
    Category("Behavior"),
    DefaultValue(""),
    Description("Wildcard pattern for thumbnail filenames (*.jpg, for example)."),
    Localizable(true)
    ]
    public virtual string ThumbFilePattern
    {
        get
        {
            string s = (string)ViewState["ThumbFilePattern"];
            return (s == null) ? "*" : s;
        }
        set
        {
            ViewState["ThumbFilePattern"] = value;
        }
    }

    [
    Bindable(true),
    Category("Behavior"),
    DefaultValue(""),
    Description("The directory where the full-size images live."),
    Localizable(true)
    ]
    public virtual string ImgSrc
    {
        get
        {
            string s = (string)ViewState["ImgSrc"];
            return (s == null) ? String.Empty : s;
        }
        set
        {
            ViewState["ImgSrc"] = value;
        }
    }

    [
    Bindable(true),
    Category("Behavior"),
    DefaultValue(""),
    Description("Wildcard pattern for full-size image filenames (*.jpg, for example)."),
    Localizable(true)
    ]
    public virtual string ImgFilePattern
    {
        get
        {
            string s = (string)ViewState["ImgFilePattern"];
            return (s == null) ? "*" : s;
        }
        set
        {
            ViewState["ImgFilePattern"] = value;
        }
    }

    [
    Bindable(true),
    Category("Behavior"),
    DefaultValue(""),
    Description("Comma-separated list of filenames to exclude from the thumb table."),
    Localizable(true)
    ]
    public virtual string ExcludeNames
    {
        get
        {
            string s = (string)ViewState["ExcludeNames"];
            return (s == null) ? "*" : s;
        }
        set
        {
            ViewState["ExcludeNames"] = value;
        }
    }

    // Reads file names from the given directory.
    //
    protected void ReadFileNames(string dir, string pattern, string toExclude, ref List<string> l)
    {
        DirectoryInfo di = new DirectoryInfo(Server.MapPath(dir));

        if (di.Exists)
        {
            if (l == null)
            {
                l = new List<string>();
            }
            List<string> names = new List<string> (toExclude.Split(','));

            FileInfo[] rgFiles = di.GetFiles(pattern);

            foreach (FileInfo fi in rgFiles)
            {
                if (names.IndexOf(fi.Name) == -1)   // not found in the exclusion list
                {
                    l.Add(fi.Name);
                }
            }
        }

    }

    protected void Page_PreRender(object sender, EventArgs e)
    {
        ReadFileNames(ThumbSrc, ThumbFilePattern, ExcludeNames, ref thumbFiles);
        ReadFileNames(ImgSrc, ImgFilePattern, ExcludeNames, ref imgFiles);

        int curColumn = ColumnsPerRow;
        int curRow = -1;
        foreach (string thumb in thumbFiles)
        {
            if (imgFiles.IndexOf(thumb) >= 0)   // need to make sure the full image for the thumbnail exists
            {
                if (curColumn >= ColumnsPerRow) // create new row?
                {
                    ThumbTable.Rows.Add(new TableRow());
                    ++curRow;
                    curColumn = 0;
                }

                HyperLink hl = new HyperLink();
                hl.ImageUrl = ThumbSrc + "/" + thumb;
                hl.NavigateUrl = ImgSrc + "/" + thumb;

                ThumbTable.Rows[curRow].Cells.Add(new TableCell());
                ThumbTable.Rows[curRow].Cells[curColumn].Controls.Add(hl);
                ++curColumn;
            }
        }
    }

    protected void Page_Dispose()
    {
        thumbFiles = null;
        imgFiles = null;
    }

    protected void Page_Load(object sender, EventArgs e)
    {

    }
}
