﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;

public partial class PagingAndSorting : System.Web.UI.Page
{
    //Set the visibility based on message.
    public string Visibility(string message)
    {
        string visibility = "visibility: {0}";

        //Generates the visibility for Mmessage
        if (message.Equals("MSG", StringComparison.CurrentCultureIgnoreCase))
            return string.Format(visibility, UserListCount == 0 ? "visible" : "hidden");

        //Generates the visibility for Navigation
        if (message.Equals("Navigation", StringComparison.CurrentCultureIgnoreCase))
            return string.Format(visibility, UserListCount == 0 ? "hidden" : "visible");

        //Generates the visibility for Repeater
        if (message.Equals("Repeater", StringComparison.CurrentCultureIgnoreCase))
            return string.Format(visibility, UserListCount > 0 ? "visible" : "hidden");

        //Default visibility
        return string.Format(visibility, "hidden");
    }

    public int UserListCount { get; set; }

    /// <summary>
    /// Create data source
    /// </summary>
    public IList<UserInfo> UserList
    {
        get
        {
            IList<UserInfo> list;

            if (ViewState["UserList"] != null)
                list = ViewState["UserList"] as IList<UserInfo>;
            else
            {
                list = new List<UserInfo>();

                Random r = new Random();
                //Generating 100 UserInfo objects

                for (int i = 1; i <= 100; i++)
                {
                    list.Add(new UserInfo()
                    {
                        FirstName = string.Format("First Name : {0}", r.Next(6 * i, 60 * i + 3)),
                        LastName = string.Format("Last Name : {0}", r.Next(11 * i, 60 * i + 7)),
                        Password = string.Format("Password : {0}", r.Next(13 * i, 60 * i + 11)),
                        UserName = string.Format("UserName : {0}", r.Next(17 * i, 60 * i + 23)),
                        LastLoginDate = DateTime.Now.AddMinutes(r.Next(7 * i, 12 * i + 13)),
                    });
                }
                ViewState["UserList"] = list;
            }

            if (list == null)
                return new List<UserInfo>();

            UserListCount = list.Count;

            string sortExpression = (ViewState["SortExpression"] ?? "").ToString();
            bool isAscending = true;

            if (ViewState["SortDetails"] == null)
            {
                Hashtable hs = new Hashtable();
                hs.Add("UserName", false);
                ViewState["SortDetails"] = hs;
            }

            Hashtable hsSortDetails = ViewState["SortDetails"] as Hashtable;

            if (sortExpression.Length > 0)
            {
                if (!hsSortDetails.Contains(sortExpression))
                    hsSortDetails.Add(sortExpression, true);
                isAscending = bool.Parse(hsSortDetails[sortExpression].ToString());
                hsSortDetails[sortExpression] = !isAscending;
            }

            switch (sortExpression)
            {
                case "UserName":
                    return list.OrderByUserName(isAscending);
                case "FirstName":
                    return list.OrderByFirstName(isAscending);
                case "LastName":
                    return list.OrderByLastName(isAscending);
                case "Password":
                    return list.OrderByPassword(isAscending);
                case "LastLoginDate":
                    return list.OrderByLastLoginDate(isAscending);
                default:
                    return list.OrderByUserName(isAscending);
            }
        }
    }

    /// <summary>
    /// Managing the new viewing page into viewstate
    /// </summary>
    public int NowViewing
    {
        get
        {
            object obj = ViewState["_NowViewing"];
            if (obj == null)
                return 0;
            else
                return (int)obj;
        }
        set
        {
            this.ViewState["_NowViewing"] = value;
        }
    }

    protected override void OnInitComplete(EventArgs e)
    {
        base.OnInitComplete(e);
        ddlPageSize.SelectedIndexChanged += new EventHandler(ddlPageSize_SelectedIndexChanged);
    }

    void ddlPageSize_SelectedIndexChanged(object sender, EventArgs e)
    {
        //Fill repeater for Pager event
        FillRepeater(Navigation.Pager);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
            FillRepeater(Navigation.None);
    }

    protected void lbtnPrev_Click(object sender, EventArgs e)
    {
        //Fill repeater for Previous event
        FillRepeater(Navigation.Previous);
    }

    /// <summary>
    /// Assign PagedDataSource to Repeater
    /// </summary>
    /// <param name="navigation">A Navigation enum to identify current page</param>
    private void FillRepeater(Navigation navigation)
    {
        //Create the object of PagedDataSource
        PagedDataSource objPds = new PagedDataSource();

        //Assign our data source to PagedDataSource object
        objPds.DataSource = UserList;

        //Set the allow paging to true
        objPds.AllowPaging = true;

        //Set the number of items you want to show
        objPds.PageSize = int.Parse(ddlPageSize.SelectedValue);

        //Based on navigation manage the NowViewing
        switch (navigation)
        {
            case Navigation.Next:       //Increment NowViewing by 1
                NowViewing++;
                break;
            case Navigation.Previous:   //Decrement NowViewing by 1
                NowViewing--;
                break;
            case Navigation.Last:       //Make NowViewing to last page for PagedDataSource
                NowViewing = objPds.PageCount - 1;
                break;
            case Navigation.Pager:      //Change NowViewing based on pager size and page count
                if (int.Parse(ddlPageSize.SelectedValue) >= objPds.PageCount)
                    NowViewing = objPds.PageCount - 1;
                break;
            case Navigation.Sorting:
                break;
            default:                    //Default NowViewing set to 0
                NowViewing = 0;
                break;
        }

        //Set the current page index
        objPds.CurrentPageIndex = NowViewing;

        //Change the text Now viewing text
        lblCurrentPage.Text = "Now viewing : " + (NowViewing + 1).ToString() + " of " + objPds.PageCount.ToString();

        // Disable Prev, Next, First, Last buttons if necessary
        lbtnPrev.Enabled = !objPds.IsFirstPage;
        lbtnNext.Enabled = !objPds.IsLastPage;
        lbtnFirst.Enabled = !objPds.IsFirstPage;
        lbtnLast.Enabled = !objPds.IsLastPage;

        //Assign PagedDataSource to repeater
        rptUsers.DataSource = objPds;
        rptUsers.DataBind();

    }

    protected void lbtnNext_Click(object sender, EventArgs e)
    {
        //Fill repeater for Next event
        FillRepeater(Navigation.Next);
    }

    protected void lbtnFirst_Click(object sender, EventArgs e)
    {
        //Fill repeater for First event
        FillRepeater(Navigation.First);
    }

    protected void lbtnLast_Click(object sender, EventArgs e)
    {
        //Fill repeater for Last event
        FillRepeater(Navigation.Last);
    }
    protected void rptUsers_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        ViewState["SortExpression"] = e.CommandName;
        FillRepeater(Navigation.Sorting);
    }
}
