﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

/// <summary>
/// Class provides the Extension methods for sorting UserInfo collection
/// </summary>
public static class Extension
{
    /// <summary>
    /// Sorts the elements of a UserInfo collection on UserName
    /// </summary>
    /// <param name="userList">A Collection of  UserInfo to order</param>
    /// <param name="isAscending">A boolean to decide the ascending or descending order</param>
    /// <returns>A collection of UserInfo whose elements are sorted according to a key and order.</returns>
    public static IList<UserInfo> OrderByUserName(this IList<UserInfo> userList, bool isAscending)
    {
        if (isAscending)
            return userList.OrderBy(a => a.UserName).ToList();
        else
            return userList.OrderByDescending(a => a.UserName).ToList();
    }

    /// <summary>
    /// Sorts the elements of a UserInfo collection on FirstName
    /// </summary>
    /// <param name="userList">A Collection of  UserInfo to order</param>
    /// <param name="isAscending">A boolean to decide the ascending or descending order</param>
    /// <returns>A collection of UserInfo whose elements are sorted according to a key and order.</returns>
    public static IList<UserInfo> OrderByFirstName(this IList<UserInfo> userList, bool isAscending)
    {
        if (isAscending)
            return userList.OrderBy(a => a.FirstName).ToList();
        else
            return userList.OrderByDescending(a => a.FirstName).ToList();
    }

    /// <summary>
    /// Sorts the elements of a UserInfo collection on LastName
    /// </summary>
    /// <param name="userList">A Collection of  UserInfo to order</param>
    /// <param name="isAscending">A boolean to decide the ascending or descending order</param>
    /// <returns>A collection of UserInfo whose elements are sorted according to a key and order.</returns>
    public static IList<UserInfo> OrderByLastName(this IList<UserInfo> userList, bool isAscending)
    {
        if (isAscending)
            return userList.OrderBy(a => a.LastName).ToList();
        else
            return userList.OrderByDescending(a => a.LastName).ToList();
    }

    /// <summary>
    /// Sorts the elements of a UserInfo collection on Password
    /// </summary>
    /// <param name="userList">A Collection of  UserInfo to order</param>
    /// <param name="isAscending">A boolean to decide the ascending or descending order</param>
    /// <returns>A collection of UserInfo whose elements are sorted according to a key and order.</returns>
    public static IList<UserInfo> OrderByPassword(this IList<UserInfo> userList, bool isAscending)
    {
        if (isAscending)
            return userList.OrderBy(a => a.Password).ToList();
        else
            return userList.OrderByDescending(a => a.Password).ToList();
    }

    /// <summary>
    /// Sorts the elements of a UserInfo collection on LastLoginDate
    /// </summary>
    /// <param name="userList">A Collection of  UserInfo to order</param>
    /// <param name="isAscending">A boolean to decide the ascending or descending order</param>
    /// <returns>A collection of UserInfo whose elements are sorted according to a key and order.</returns>
    public static IList<UserInfo> OrderByLastLoginDate(this IList<UserInfo> userList, bool isAscending)
    {
        if (isAscending)
            return userList.OrderBy(a => a.LastLoginDate).ToList();
        else
            return userList.OrderByDescending(a => a.LastLoginDate).ToList();
    }
}
